/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.persistence.impl;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.impl.MBMessageImpl;
import com.liferay.message.boards.service.persistence.MBMessageFinder;
import com.liferay.message.boards.service.persistence.impl.MBMessageFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MBMessageFinder.class})
public class MBMessageFinderImpl
extends MBMessageFinderBaseImpl
implements MBMessageFinder {
    public static final String COUNT_BY_PARENT_MESSAGE_ID = MBMessageFinder.class.getName() + ".countByParentMessageId";
    public static final String COUNT_BY_C_T = MBMessageFinder.class.getName() + ".countByC_T";
    public static final String COUNT_BY_G_U_C_S = MBMessageFinder.class.getName() + ".countByG_U_C_S";
    public static final String COUNT_BY_G_U_C_A_S = MBMessageFinder.class.getName() + ".countByG_U_C_A_S";
    public static final String COUNT_BY_G_U_MD_C_A_S = MBMessageFinder.class.getName() + ".countByG_U_MD_C_A_S";
    public static final String FIND_BY_PARENT_MESSAGE_ID = MBMessageFinder.class.getName() + ".findByParentMessageId";
    public static final String FIND_BY_THREAD_ID = MBMessageFinder.class.getName() + ".findByThreadId";
    public static final String FIND_BY_G_U_C_S = MBMessageFinder.class.getName() + ".findByG_U_C_S";
    public static final String FIND_BY_G_U_C_A_S = MBMessageFinder.class.getName() + ".findByG_U_C_A_S";
    public static final String FIND_BY_G_U_MD_C_A_S = MBMessageFinder.class.getName() + ".findByG_U_MD_C_A_S";
    private static final String _USER_ID_SQL = "AND (currentMessage.userId = ?)";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private Portal _portal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countByParentMessageId(long parentMessageId, boolean flatten, QueryDefinition<MBMessage> queryDefinition) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_PARENT_MESSAGE_ID, queryDefinition, "MBMessage");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(flatten);
            queryPos.add(parentMessageId);
            queryPos.add(flatten);
            queryPos.add("%/" + parentMessageId + "/_%");
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByC_T(Date createDate, long threadId) {
        Timestamp createDate_TS = CalendarUtil.getTimestamp((Date)createDate);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_C_T);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(createDate_TS);
            queryPos.add(threadId);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, false);
    }

    public int countByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, false);
    }

    public int filterCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, true);
    }

    public int filterCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, true);
    }

    public int filterCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status) {
        return this.doCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, true);
    }

    public int filterCountByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, anonymous, status, true);
    }

    public List<Long> filterFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, true);
    }

    public List<Long> filterFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, anonymous, status, start, end, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MBMessage> findByParentMessageId(long parentMessageId, boolean flatten, QueryDefinition<MBMessage> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_PARENT_MESSAGE_ID, queryDefinition, "MBMessage");
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBMessage", MBMessageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(flatten);
            queryPos.add(parentMessageId);
            queryPos.add(flatten);
            queryPos.add("%/" + parentMessageId + "/_%");
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MBMessage> findByThreadId(long threadId, QueryDefinition<MBMessage> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_THREAD_ID, queryDefinition, "MBMessage");
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBMessage", MBMessageImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(threadId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, false);
    }

    public List<Long> findByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, false);
    }

    protected int doCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            if (status != -1) {
                queryPos.add(status);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C_A_S);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (status != -1) {
                queryPos.add(status);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, boolean inlineSQLHelper) {
        return this.doCountByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, true, status, inlineSQLHelper);
    }

    protected int doCountByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_MD_C_A_S);
            if (userId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (!anonymous) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.anonymous = [$FALSE$])");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            queryPos.add(modifiedDate);
            if (status != -1) {
                queryPos.add(status);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("threadId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            if (status != -1) {
                queryPos.add(status);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_A_S);
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("threadId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(userId);
            queryPos.add(anonymous);
            if (status != -1) {
                queryPos.add(status);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) {
        return this.doFindByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, true, status, start, end, inlineSQLHelper);
    }

    protected List<Long> doFindByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_MD_C_A_S);
            if (userId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)_USER_ID_SQL);
            }
            if (ArrayUtil.isEmpty((long[])categoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(currentMessage.categoryId = ?) AND");
            } else {
                String mergedCategoryIds = StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ");
                sql = StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + mergedCategoryIds));
            }
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (!anonymous) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.anonymous = [$FALSE$])");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("threadId", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            if (userId > 0L) {
                queryPos.add(userId);
            }
            queryPos.add(modifiedDate);
            if (status != -1) {
                queryPos.add(status);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

