/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search.spi.model.query.contributor;

import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={ModelPreFilterContributor.class})
public class MBMessageModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected MBCategoryService mbCategoryService;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    protected ModelPreFilterContributor workflowStatusModelPreFilterContributor;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageModelPreFilterContributor.class);
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();

    public void addRelatedClassNames(BooleanFilter contextFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextFilter, searchContext);
    }

    public void contribute(BooleanFilter booleanFilter, final ModelSearchSettings modelSearchSettings, final SearchContext searchContext) {
        long[] categoryIds;
        long threadId;
        String classNameId;
        booleanFilter.add((Filter)new BooleanFilter(){
            {
                this.add((Filter)new BooleanFilter(){
                    {
                        MBMessageModelPreFilterContributor.this.addWorkflowStatusFilter(this, modelSearchSettings, searchContext);
                    }
                }, BooleanClauseOccur.SHOULD);
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                final User user = permissionChecker.getUser();
                long groupId = 0L;
                if (user.getGroup() != null) {
                    groupId = user.getGroupId();
                }
                if (permissionChecker.isContentReviewer(CompanyThreadLocal.getCompanyId().longValue(), groupId)) {
                    this.add((Filter)new BooleanFilter(){
                        {
                            this.add((Filter)new TermFilter("status", String.valueOf(1)), BooleanClauseOccur.MUST);
                        }
                    }, BooleanClauseOccur.SHOULD);
                }
                this.add((Filter)new BooleanFilter(){
                    {
                        this.add((Filter)new TermFilter("status", String.valueOf(1)), BooleanClauseOccur.MUST);
                        this.add((Filter)new TermFilter("userId", String.valueOf(user.getUserId())), BooleanClauseOccur.MUST);
                    }
                }, BooleanClauseOccur.SHOULD);
            }
        }, BooleanClauseOccur.MUST);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"));
        booleanFilter.addRequiredTerm("discussion", discussion);
        if (searchContext.isIncludeDiscussions()) {
            try {
                this.addRelatedClassNames(booleanFilter, searchContext);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
        if (Validator.isNotNull((String)(classNameId = GetterUtil.getString((Object)searchContext.getAttribute("classNameId"))))) {
            booleanFilter.addRequiredTerm("classNameId", classNameId);
        }
        if ((threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))))) > 0L) {
            booleanFilter.addRequiredTerm("threadId", threadId);
        }
        if ((categoryIds = searchContext.getCategoryIds()) != null && categoryIds.length > 0 && categoryIds[0] != 0L) {
            TermsFilter categoriesTermsFilter = new TermsFilter("categoryId");
            for (long categoryId : categoryIds) {
                try {
                    this.mbCategoryService.getCategory(categoryId);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get message boards category " + categoryId), (Throwable)portalException);
                    continue;
                }
                categoriesTermsFilter.addValue(String.valueOf(categoryId));
            }
            if (!categoriesTermsFilter.isEmpty()) {
                booleanFilter.add((Filter)categoriesTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    protected void addWorkflowStatusFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.workflowStatusModelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext);
    }
}

