/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageModel;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.WorkflowedModelPermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class MBMessagePermissionRegistrar {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private MBBanLocalService _mbBanLocalService;
    @Reference
    private MBCategoryLocalService _mbCategoryLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _mbCategoryModelResourcePermission;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference(target="(resource.name=com.liferay.message.boards)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission<MBMessage>> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference
    private WorkflowPermission _workflowPermission;

    @Activate
    protected void activate(BundleContext bundleContext) {
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)MBMessage.class.getName()).build();
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(MBMessage.class, MBMessageModel::getMessageId, resourcePrimKey -> {
            MBThread mbThread = this._mbThreadLocalService.fetchThread(resourcePrimKey.longValue());
            if (mbThread == null) {
                return this._mbMessageLocalService.getMessage(resourcePrimKey.longValue());
            }
            return this._mbMessageLocalService.getMessage(mbThread.getRootMessageId());
        }, (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept((permissionChecker, name, message, actionId) -> {
                if (this._mbBanLocalService.hasBan(message.getGroupId(), permissionChecker.getUserId())) {
                    return false;
                }
                MBThread thread = message.getThread();
                if (!message.isRoot() && !modelResourcePermission.contains(permissionChecker, thread.getRootMessageId(), "VIEW")) {
                    return false;
                }
                return null;
            });
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_message_boards_web_portlet_MBPortlet", MBMessageModel::getMessageId));
            consumer.accept(new WorkflowedModelPermissionLogic(this._workflowPermission, modelResourcePermission, this._groupLocalService, MBMessageModel::getMessageId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(this._mbCategoryModelResourcePermission, this._getFetchParentFunction(), false));
            }
        }), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<MBMessage, MBCategory, PortalException> _getFetchParentFunction() {
        return message -> {
            long categoryId = message.getCategoryId();
            if (-1L == categoryId || 0L == categoryId) {
                return null;
            }
            if (message.isInTrash()) {
                return this._mbCategoryLocalService.fetchMBCategory(categoryId);
            }
            return this._mbCategoryLocalService.getCategory(categoryId);
        };
    }
}

