/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v3_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MBMessageTreePathUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._populateTreePath();
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"MBMessage", (String[])new String[]{"treePath STRING null"})};
    }

    private String _calculatePath(Map<Long, Long> relations, long messageId) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(messageId + "/");
        while (relations.containsKey(messageId)) {
            messageId = relations.get(messageId);
            paths.add(messageId + "/");
        }
        paths.add("/");
        Collections.reverse(paths);
        return StringUtil.merge(paths, (String)"");
    }

    private void _populateTreePath() throws Exception {
        Throwable throwable;
        this.runSQL("update MBMessage set treePath = CONCAT('/', CAST_TEXT(messageId), '/') where parentMessageId = 0");
        this.runSQL("update MBMessage set treePath = CONCAT('/', CAST_TEXT(rootMessageId), '/', CAST_TEXT(messageId), '/') where parentMessageId = rootMessageId");
        HashMap<Long, Long> relations = new HashMap<Long, Long>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select messageId, parentMessageId from MBMessage where parentMessageId != 0 order by createDate desc");){
            throwable = null;
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    relations.put(resultSet.getLong(1), resultSet.getLong(2));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select messageId from MBMessage where treePath is null or treePath = ''");){
            throwable = null;
            try (PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update MBMessage set treePath = ? where messageId = ?");
                 ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long messageId = resultSet.getLong(1);
                    preparedStatement2.setString(1, this._calculatePath(relations, messageId));
                    preparedStatement2.setLong(2, messageId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }
}

