/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.view.count.model.listener;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.listener.ViewCountEntryModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ViewCountEntryModelListener.class})
public class MBThreadViewCountEntryModelListener
implements ViewCountEntryModelListener {
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;

    public String getModelClassName() {
        return MBThread.class.getName();
    }

    public void onAfterIncrement(ViewCountEntry viewCountEntry) {
        MBThread mbThread = this._mbThreadLocalService.fetchMBThread(viewCountEntry.getClassPK());
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(mbThread.getRootMessageId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        try {
            indexer.reindex((Object)mbMessage);
        }
        catch (SearchException searchException) {
            ReflectionUtil.throwException((Throwable)searchException);
        }
    }
}

