/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBThreadFlag;
import com.liferay.message.boards.service.base.MBThreadFlagLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBThreadFlag"}, service={AopService.class})
public class MBThreadFlagLocalServiceImpl
extends MBThreadFlagLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public MBThreadFlag addThreadFlag(long userId, MBThread thread, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (user.isGuestUser()) {
            return null;
        }
        long threadId = thread.getThreadId();
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.fetchByU_T(userId, threadId);
        if (threadFlag != null && DateUtil.equals((Date)threadFlag.getModifiedDate(), (Date)thread.getLastPostDate())) {
            return threadFlag;
        }
        if (threadFlag == null) {
            long threadFlagId = this.counterLocalService.increment();
            threadFlag = this.mbThreadFlagPersistence.create(threadFlagId);
            threadFlag.setUuid(serviceContext.getUuid());
            threadFlag.setGroupId(thread.getGroupId());
            threadFlag.setCompanyId(user.getCompanyId());
            threadFlag.setUserId(userId);
            threadFlag.setUserName(user.getFullName());
            threadFlag.setModifiedDate(serviceContext.getModifiedDate(thread.getLastPostDate()));
            threadFlag.setThreadId(threadId);
        } else {
            threadFlag.setModifiedDate(thread.getLastPostDate());
        }
        return this.mbThreadFlagLocalService.updateMBThreadFlag(threadFlag);
    }

    public void deleteThreadFlag(long threadFlagId) throws PortalException {
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.findByPrimaryKey(threadFlagId);
        this.mbThreadFlagLocalService.deleteThreadFlag(threadFlag);
    }

    @SystemEvent(type=1)
    public void deleteThreadFlag(MBThreadFlag threadFlag) {
        this.mbThreadFlagPersistence.remove((BaseModel)threadFlag);
    }

    public void deleteThreadFlagsByThreadId(long threadId) {
        List threadFlags = this.mbThreadFlagPersistence.findByThreadId(threadId);
        for (MBThreadFlag threadFlag : threadFlags) {
            this.mbThreadFlagLocalService.deleteThreadFlag(threadFlag);
        }
    }

    public void deleteThreadFlagsByUserId(long userId) {
        List threadFlags = this.mbThreadFlagPersistence.findByUserId(userId);
        for (MBThreadFlag threadFlag : threadFlags) {
            this.mbThreadFlagLocalService.deleteThreadFlag(threadFlag);
        }
    }

    public MBThreadFlag getThreadFlag(long userId, MBThread thread) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (user.isGuestUser()) {
            return null;
        }
        return this.mbThreadFlagPersistence.fetchByU_T(userId, thread.getThreadId());
    }

    public boolean hasThreadFlag(long userId, MBThread thread) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        if (user.isGuestUser()) {
            return true;
        }
        MBThreadFlag threadFlag = this.mbThreadFlagPersistence.fetchByU_T(userId, thread.getThreadId());
        return threadFlag != null && DateUtil.equals((Date)threadFlag.getModifiedDate(), (Date)thread.getLastPostDate());
    }
}

