/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class MBBanStagedModelDataHandler
extends BaseStagedModelDataHandler<MBBan> {
    public static final String[] CLASS_NAMES = new String[]{MBBan.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(MBBanStagedModelDataHandler.class);
    @Reference
    private MBBanLocalService _mbBanLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void deleteStagedModel(MBBan ban) {
        this._mbBanLocalService.deleteBan(ban);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MBBan ban = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ban != null) {
            this.deleteStagedModel(ban);
        }
    }

    public MBBan fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbBanLocalService.fetchMBBanByUuidAndGroupId(uuid, groupId);
    }

    public List<MBBan> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbBanLocalService.getMBBansByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBBan ban) throws Exception {
        Element userBanElement = portletDataContext.getExportDataElement((ClassedModel)ban);
        ban.setBanUserUuid(ban.getBanUserUuid());
        User bannedUser = this._userLocalService.getUser(ban.getUserId());
        portletDataContext.addReferenceElement((ClassedModel)ban, userBanElement, (ClassedModel)bannedUser, "disposable_dependency", true);
        portletDataContext.addClassedModel(userBanElement, ExportImportPathUtil.getModelPath((StagedModel)ban), (ClassedModel)ban);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBBan ban) throws Exception {
        User user = this._userLocalService.fetchUserByUuidAndCompanyId(ban.getBanUserUuid(), portletDataContext.getCompanyId());
        if (user == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to find banned user with uuid " + ban.getBanUserUuid()));
            }
            return;
        }
        long userId = portletDataContext.getUserId(ban.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)ban);
        serviceContext.setUuid(ban.getUuid());
        this._mbBanLocalService.addBan(userId, user.getUserId(), serviceContext);
    }

    protected boolean isSkipImportReferenceStagedModels() {
        return true;
    }
}

