/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={ModelDocumentContributor.class})
public class MBMessageModelDocumentContributor
implements ModelDocumentContributor<MBMessage> {
    @Reference
    protected CommentManager commentManager;
    @Reference
    protected MBDiscussionLocalService mbDiscussionLocalService;
    @Reference
    protected MBThreadLocalService mbThreadLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageModelDocumentContributor.class);
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;

    public void contribute(Document document, MBMessage mbMessage) {
        document.addKeyword("categoryId", mbMessage.getCategoryId());
        for (Locale locale : this._language.getAvailableLocales(mbMessage.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(this._localization.getLocalizedName("content", languageId), this._processContent(mbMessage));
            document.addText(this._localization.getLocalizedName("title", languageId), mbMessage.getSubject());
        }
        document.addKeyword("rootEntryClassPK", mbMessage.getRootMessageId());
        document.addKeyword("treePath", StringUtil.split((String)mbMessage.getTreePath(), (char)'/'));
        if (mbMessage.isAnonymous()) {
            document.remove("userName");
        }
        document.addKeywordSortable("answer", Boolean.valueOf(mbMessage.isAnswer()));
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchThreadDiscussion(mbMessage.getThreadId());
        if (discussion == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        document.addKeyword("parentMessageId", mbMessage.getParentMessageId());
        document.addKeyword("threadId", mbMessage.getThreadId());
        document.addKeywordSortable("urlSubject", mbMessage.getUrlSubject());
        if (mbMessage.getMessageId() == mbMessage.getRootMessageId()) {
            boolean answered = false;
            for (MBMessage childMBMessage : this._mbMessageLocalService.getChildMessages(mbMessage.getMessageId(), 0)) {
                if (!childMBMessage.isAnswer()) continue;
                answered = true;
                break;
            }
            document.addKeyword("answered", answered);
            document.addKeyword("childMessagesCount", this._mbMessageLocalService.getChildMessagesCount(mbMessage.getMessageId(), 0));
            MBThread mbThread = this.mbThreadLocalService.fetchMBThread(mbMessage.getThreadId());
            document.addKeyword("question", mbThread.isQuestion());
            RatingsStats ratingsStats = this._ratingsStatsLocalService.fetchStats(MBMessage.class.getName(), mbThread.getRootMessageId());
            if (ratingsStats != null) {
                document.addNumber("ratingsStatTotalScore", ratingsStats.getTotalScore());
            }
            document.addNumber("viewCount", mbThread.getViewCount());
        }
        if (!mbMessage.isDiscussion()) {
            return;
        }
        List relatedEntryIndexers = RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers((String)mbMessage.getClassName());
        if (relatedEntryIndexers != null) {
            for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                Comment comment = this.commentManager.fetchComment(mbMessage.getMessageId());
                if (comment == null) continue;
                try {
                    relatedEntryIndexer.addRelatedEntryFields(document, (Object)comment);
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
                document.addKeyword("relatedEntry", true);
            }
        }
    }

    private String _processContent(MBMessage message) {
        String content = message.getBody();
        try {
            if (message.isFormatBBCode()) {
                content = BBCodeTranslatorUtil.getHTML((String)content);
            }
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", exception.getMessage()}), (Throwable)exception);
        }
        return this._htmlParser.extractText(content);
    }
}

