/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v6_5_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class FriendlyURLUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (SafeCloseable safeCloseable = this.addTemporaryIndex("MBCategory", false, new String[]{"name"});
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select categoryId, name from MBCategory order by name, categoryId asc");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update MBCategory set friendlyURL = ? where categoryId = ?");){
            int count = 0;
            String currentFriendlyURL = null;
            String previousFriendlyURL = null;
            while (resultSet.next()) {
                long categoryId = resultSet.getLong(1);
                String name = resultSet.getString(2);
                currentFriendlyURL = this._getFriendlyURL(categoryId, name);
                String suffix = null;
                if (StringUtil.equals(previousFriendlyURL, (String)currentFriendlyURL)) {
                    suffix = "-" + ++count;
                } else {
                    count = 0;
                    previousFriendlyURL = currentFriendlyURL;
                    suffix = "";
                }
                preparedStatement2.setString(1, currentFriendlyURL + suffix);
                preparedStatement2.setLong(2, categoryId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"MBCategory", (String[])new String[]{"friendlyURL VARCHAR(255)"})};
    }

    private String _getFriendlyURL(long id, String name) {
        if (name == null) {
            return String.valueOf(id);
        }
        name = Validator.isNull((String)(name = StringUtil.toLowerCase((String)name.trim()))) || Validator.isNumber((String)name) || name.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)name);
        return name.substring(0, Math.min(name.length(), 254));
    }
}

