/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MBUtil {
    public static void propagatePermissions(long companyId, long groupId, long parentMessageId, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMBMessage((long)parentMessageId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole((long)groupId);
        Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)MBMessage.class.getName());
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)MBMessage.class.getName(), (int)4, (String)String.valueOf(parentMessage.getMessageId()), (Collection)actionIds);
        String[] groupPermissions = MBUtil._getRolePermissions(defaultGroupRole, roleIdsToActionIds);
        String[] guestPermissions = MBUtil._getRolePermissions(guestRole, roleIdsToActionIds);
        serviceContext.setModelPermissions(ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions, (String)MBMessage.class.getName()));
    }

    public static String replaceMessageBodyPaths(ThemeDisplay themeDisplay, String messageBody) {
        return StringUtil.replace((String)messageBody, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
    }

    private static String[] _getRolePermissions(Role role, Map<Long, Set<String>> roleIdsToActionIds) {
        String[] rolePermissions = null;
        Set<String> defaultRoleActionIds = roleIdsToActionIds.get(role.getRoleId());
        rolePermissions = defaultRoleActionIds != null ? defaultRoleActionIds.toArray(new String[0]) : new String[]{};
        return rolePermissions;
    }
}

