/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MBTreeWalkerImpl
implements MBTreeWalker {
    private static final Log _log = LogFactoryUtil.getLog(MBTreeWalkerImpl.class);
    private final Map<Long, Integer> _messageIdsMap = new HashMap<Long, Integer>();
    private final List<MBMessage> _messages;
    private boolean _odd;
    private final MBMessage _rootMessage;

    public MBTreeWalkerImpl(List<MBMessage> messages) {
        MBMessage rootMessage = null;
        try {
            for (int i = 0; i < messages.size(); ++i) {
                MBMessage curMessage = messages.get(i);
                if (curMessage.isRoot()) {
                    rootMessage = curMessage;
                }
                long parentMessageId = curMessage.getParentMessageId();
                if (curMessage.isRoot() || this._messageIdsMap.containsKey(parentMessageId)) continue;
                this._messageIdsMap.put(parentMessageId, i);
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize tree walker", (Throwable)exception);
        }
        this._messages = messages;
        this._rootMessage = rootMessage;
    }

    public List<MBMessage> getChildren(MBMessage message) {
        ArrayList<MBMessage> children = new ArrayList<MBMessage>();
        int[] range = this.getChildrenRange(message);
        for (int i = range[0]; i < range[1]; ++i) {
            children.add(this._messages.get(i));
        }
        return children;
    }

    public int[] getChildrenRange(MBMessage message) {
        MBMessage curMessage;
        long messageId = message.getMessageId();
        Integer pos = this._messageIdsMap.get(messageId);
        if (pos == null) {
            return new int[]{0, 0};
        }
        int[] range = new int[2];
        range[0] = pos;
        for (int i = range[0]; i < this._messages.size() && (curMessage = this._messages.get(i)).getParentMessageId() == messageId; ++i) {
            range[1] = i + 1;
        }
        return range;
    }

    public List<MBMessage> getMessages() {
        return this._messages;
    }

    public MBMessage getRoot() {
        return this._rootMessage;
    }

    public boolean isLeaf(MBMessage message) {
        Long messageIdObj = message.getMessageId();
        return !this._messageIdsMap.containsKey(messageIdObj);
    }

    public boolean isOdd() {
        this._odd = !this._odd;
        return this._odd;
    }
}

