/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.message.boards.constants.MBCategoryConstants;
import com.liferay.message.boards.exception.CategoryNameException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMailingList;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.impl.MBCategoryImpl;
import com.liferay.message.boards.service.MBMailingListLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.base.MBCategoryLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.message.boards.service.persistence.MBThreadPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBCategory"}, service={AopService.class})
public class MBCategoryLocalServiceImpl
extends MBCategoryLocalServiceBaseImpl {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    @Reference
    private MBMailingListLocalService _mbMailingListLocalService;
    @Reference
    private MBMessagePersistence _mbMessagePersistence;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MBThreadPersistence _mbThreadPersistence;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this.mbCategoryLocalService.addCategory(userId, parentCategoryId, name, description, MBCategoryConstants.DEFAULT_DISPLAY_STYLE, null, null, null, 0, false, null, null, 0, null, false, null, 0, false, null, null, false, false, serviceContext);
    }

    public MBCategory addCategory(long userId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentCategoryId = this._getParentCategoryId(groupId, parentCategoryId);
        this._validate(name);
        long categoryId = this.counterLocalService.increment();
        MBCategory category = this.mbCategoryPersistence.create(categoryId);
        category.setUuid(serviceContext.getUuid());
        category.setGroupId(groupId);
        category.setCompanyId(user.getCompanyId());
        category.setUserId(user.getUserId());
        category.setUserName(user.getFullName());
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        category.setDisplayStyle(displayStyle);
        category.setFriendlyURL(this._getUniqueFriendlyURL(groupId, categoryId, name));
        category.setExpandoBridgeAttributes(serviceContext);
        category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addCategoryResources(category, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addCategoryResources(category, serviceContext.getModelPermissions());
        }
        this._mbMailingListLocalService.addMailingList(userId, groupId, category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        return category;
    }

    public void addCategoryResources(long categoryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(long categoryId, ModelPermissions modelPermissions) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.addCategoryResources(category, modelPermissions);
    }

    public void addCategoryResources(MBCategory category, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addCategoryResources(MBCategory category, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(category.getCompanyId(), category.getGroupId(), category.getUserId(), MBCategory.class.getName(), category.getCategoryId(), modelPermissions);
    }

    public void deleteCategories(long groupId) throws PortalException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.mbCategoryLocalService.deleteCategory(category);
        }
    }

    public void deleteCategory(long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        this.mbCategoryLocalService.deleteCategory(category);
    }

    public void deleteCategory(MBCategory category) throws PortalException {
        this.mbCategoryLocalService.deleteCategory(category, true);
    }

    @SystemEvent(action=1, type=1)
    public void deleteCategory(MBCategory category, boolean includeTrashedEntries) throws PortalException {
        List categories = this.mbCategoryPersistence.findByG_P(category.getGroupId(), category.getCategoryId());
        for (MBCategory curCategory : categories) {
            if (!includeTrashedEntries && this._trashHelper.isInTrashExplicitly((TrashedModel)curCategory)) continue;
            this.mbCategoryLocalService.deleteCategory(curCategory, includeTrashedEntries);
        }
        this._mbThreadLocalService.deleteThreads(category.getGroupId(), category.getCategoryId(), includeTrashedEntries);
        MBMailingList mbMailingList = this._mbMailingListLocalService.fetchCategoryMailingList(category.getGroupId(), category.getCategoryId());
        if (mbMailingList != null) {
            this._mbMailingListLocalService.deleteMailingList(mbMailingList);
        }
        this._subscriptionLocalService.deleteSubscriptions(category.getCompanyId(), MBCategory.class.getName(), category.getCategoryId());
        this._expandoRowLocalService.deleteRows(category.getCategoryId());
        this._ratingsStatsLocalService.deleteStats(MBCategory.class.getName(), category.getCategoryId());
        this._resourceLocalService.deleteResource(category.getCompanyId(), MBCategory.class.getName(), 4, category.getCategoryId());
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)category)) {
            this._trashEntryLocalService.deleteEntry(MBCategory.class.getName(), category.getCategoryId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(MBCategory.class.getName(), category.getCategoryId());
        }
        this.mbCategoryLocalService.deleteMBCategory(category);
    }

    public MBCategory fetchMBCategory(long groupId, String friendlyURL) {
        return this.mbCategoryPersistence.fetchByG_F(groupId, friendlyURL);
    }

    public List<MBCategory> getCategories(long groupId) {
        return this.mbCategoryPersistence.findByGroupId(groupId);
    }

    public List<MBCategory> getCategories(long groupId, int status) {
        return this.mbCategoryPersistence.findByG_S(groupId, status);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int start, int end) {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long excludedCategoryId, long parentCategoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByNotC_G_P(excludedCategoryId, groupId, parentCategoryId, start, end);
        }
        return this.mbCategoryPersistence.findByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int start, int end) {
        return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByG_P(groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.findByG_P_S(groupId, parentCategoryIds, status, start, end);
    }

    public List<MBCategory> getCategories(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status, int start, int end) {
        if (status == -1) {
            return this.mbCategoryPersistence.findByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds, start, end);
        }
        return this.mbCategoryPersistence.findByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status, start, end);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public List<Object> getCategoriesAndThreads(long groupId, long categoryId, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.mbCategoryFinder.findC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.countC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesAndThreadsCount(long groupId, long categoryId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.mbCategoryFinder.countC_T_ByG_C(groupId, categoryId, queryDefinition);
    }

    public int getCategoriesCount(long groupId) {
        return this.mbCategoryPersistence.countByGroupId(groupId);
    }

    public int getCategoriesCount(long groupId, int status) {
        return this.mbCategoryPersistence.countByG_S(groupId, status);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId) {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
    }

    public int getCategoriesCount(long groupId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long excludedCategoryId, long parentCategoryId, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByNotC_G_P(excludedCategoryId, groupId, parentCategoryId);
        }
        return this.mbCategoryPersistence.countByNotC_G_P_S(excludedCategoryId, groupId, parentCategoryId, status);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds) {
        return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
    }

    public int getCategoriesCount(long groupId, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByG_P(groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.countByG_P_S(groupId, parentCategoryIds, status);
    }

    public int getCategoriesCount(long groupId, long[] excludedCategoryIds, long[] parentCategoryIds, int status) {
        if (status == -1) {
            return this.mbCategoryPersistence.countByNotC_G_P(excludedCategoryIds, groupId, parentCategoryIds);
        }
        return this.mbCategoryPersistence.countByNotC_G_P_S(excludedCategoryIds, groupId, parentCategoryIds, status);
    }

    public MBCategory getCategory(long categoryId) throws PortalException {
        MBCategoryImpl category = null;
        if (categoryId != 0L && categoryId != -1L) {
            category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(categoryId);
            category.setParentCategoryId(categoryId);
        }
        return category;
    }

    public List<MBCategory> getCompanyCategories(long companyId, int start, int end) {
        return this.mbCategoryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyCategoriesCount(long companyId) {
        return this.mbCategoryPersistence.countByCompanyId(companyId);
    }

    public MBCategory getMBCategory(long groupId, String friendlyURL) throws PortalException {
        return this.mbCategoryPersistence.findByG_F(groupId, friendlyURL);
    }

    public List<Long> getSubcategoryIds(List<Long> categoryIds, long groupId, long categoryId) {
        List categories = this.mbCategoryPersistence.findByG_P(groupId, categoryId);
        for (MBCategory category : categories) {
            categoryIds.add(category.getCategoryId());
            this.getSubcategoryIds(categoryIds, category.getGroupId(), category.getCategoryId());
        }
        return categoryIds;
    }

    public List<MBCategory> getSubscribedCategories(long groupId, long userId, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, null);
        return this.mbCategoryFinder.findC_ByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public int getSubscribedCategoriesCount(long groupId, long userId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.mbCategoryFinder.countC_ByS_G_U_P(groupId, userId, null, queryDefinition);
    }

    public void moveCategoriesToTrash(long groupId, long userId) throws PortalException {
        List categories = this.mbCategoryPersistence.findByGroupId(groupId);
        for (MBCategory category : categories) {
            this.moveCategoryToTrash(userId, category.getCategoryId());
        }
    }

    public MBCategory moveCategory(long categoryId, long parentCategoryId, boolean mergeWithParentCategory) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this._getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this._mergeCategories(category, parentCategoryId);
            return category;
        }
        category.setParentCategoryId(parentCategoryId);
        category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
        this._reindex(MBCategory.class, category);
        return category;
    }

    public MBCategory moveCategoryFromTrash(long userId, long categoryId, long newCategoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (!category.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)category)) {
            this.restoreCategoryFromTrash(userId, categoryId);
        } else {
            TrashVersion trashVersion = this._trashVersionLocalService.fetchVersion(MBCategory.class.getName(), category.getCategoryId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, categoryId, status);
            if (trashVersion != null) {
                this._trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this._restoreDependentsFromTrash(this._userLocalService.getUser(userId), this.getCategoriesAndThreads(category.getGroupId(), categoryId, 8));
        }
        return this.moveCategory(categoryId, newCategoryId, false);
    }

    public MBCategory moveCategoryToTrash(long userId, long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (category.isInTrash()) {
            throw new TrashEntryException();
        }
        category = this.updateStatus(userId, categoryId, 8);
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, category.getGroupId(), MBCategory.class.getName(), categoryId, category.getUuid(), null, 0, null, null);
        this._moveDependentsToTrash(this._userLocalService.getUser(userId), this.getCategoriesAndThreads(category.getGroupId(), categoryId), trashEntry.getEntryId());
        this._reindex(MBCategory.class, category);
        return category;
    }

    public void restoreCategoryFromTrash(long userId, long categoryId) throws PortalException {
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        if (!category.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(MBCategory.class.getName(), categoryId);
        category = this.updateStatus(userId, categoryId, 0);
        this._restoreDependentsFromTrash(this._userLocalService.getUser(userId), this.getCategoriesAndThreads(category.getGroupId(), categoryId, 8));
        this._trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
    }

    public void subscribeCategory(long userId, long groupId, long categoryId) throws PortalException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, MBCategory.class.getName(), categoryId);
    }

    public void unsubscribeCategory(long userId, long groupId, long categoryId) throws PortalException {
        if (categoryId == 0L) {
            categoryId = groupId;
        }
        this._subscriptionLocalService.deleteSubscription(userId, MBCategory.class.getName(), categoryId);
    }

    public MBCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, String displayStyle, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean mailingListActive, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException {
        if (categoryId == 0L || categoryId == -1L) {
            return null;
        }
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        parentCategoryId = this._getParentCategoryId(category, parentCategoryId);
        if (mergeWithParentCategory && categoryId != parentCategoryId && parentCategoryId != 0L && parentCategoryId != -1L) {
            this._mergeCategories(category, parentCategoryId);
            return category;
        }
        this._validate(name);
        category.setParentCategoryId(parentCategoryId);
        category.setName(name);
        category.setDescription(description);
        if (!displayStyle.equals(category.getDisplayStyle())) {
            category.setDisplayStyle(displayStyle);
            this._updateChildCategoriesDisplayStyle(category, displayStyle);
        }
        category.setExpandoBridgeAttributes(serviceContext);
        category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
        this._reindex(MBCategory.class, category);
        MBMailingList mailingList = this._mbMailingListLocalService.fetchCategoryMailingList(category.getGroupId(), category.getCategoryId());
        if (mailingList != null) {
            this._mbMailingListLocalService.updateMailingList(mailingList.getMailingListId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        } else {
            this._mbMailingListLocalService.addMailingList(category.getUserId(), category.getGroupId(), category.getCategoryId(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        }
        return category;
    }

    public MBCategory updateStatus(long userId, long categoryId, int status) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(categoryId);
        category.setStatus(status);
        category.setStatusByUserId(user.getUserId());
        category.setStatusByUserName(user.getFullName());
        category.setStatusDate(new Date());
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
    }

    private long _getParentCategoryId(long groupId, long parentCategoryId) {
        MBCategory parentCategory;
        if (parentCategoryId != 0L && parentCategoryId != -1L && ((parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId)) == null || groupId != parentCategory.getGroupId())) {
            parentCategoryId = 0L;
        }
        return parentCategoryId;
    }

    private long _getParentCategoryId(MBCategory category, long parentCategoryId) {
        if (parentCategoryId == 0L || parentCategoryId == -1L) {
            return parentCategoryId;
        }
        if (category.getCategoryId() == parentCategoryId) {
            return category.getParentCategoryId();
        }
        MBCategory parentCategory = this.mbCategoryPersistence.fetchByPrimaryKey(parentCategoryId);
        if (parentCategory == null || category.getGroupId() != parentCategory.getGroupId()) {
            return category.getParentCategoryId();
        }
        ArrayList<Long> subcategoryIds = new ArrayList<Long>();
        this.getSubcategoryIds(subcategoryIds, category.getGroupId(), category.getCategoryId());
        if (subcategoryIds.contains(parentCategoryId)) {
            return category.getParentCategoryId();
        }
        return parentCategoryId;
    }

    private String _getUniqueFriendlyURL(long groupId, long categoryId, String name) {
        if (Validator.isNull((String)name)) {
            return String.valueOf(categoryId);
        }
        name = Validator.isNull((String)(name = StringUtil.toLowerCase((String)name.trim()))) || Validator.isNumber((String)name) ? String.valueOf(categoryId) : this._friendlyURLNormalizer.normalizeWithPeriodsAndSlashes(name);
        String friendlyURL = name = ModelHintsUtil.trimString((String)MBCategory.class.getName(), (String)"friendlyURL", (String)name);
        MBCategory mbCategory = this.mbCategoryPersistence.fetchByG_F(groupId, friendlyURL);
        int i = 1;
        while (mbCategory != null) {
            friendlyURL = name + "-" + i;
            mbCategory = this.mbCategoryPersistence.fetchByG_F(groupId, friendlyURL);
            ++i;
        }
        return friendlyURL;
    }

    private void _mergeCategories(MBCategory fromCategory, long toCategoryId) throws PortalException {
        if (toCategoryId == 0L || toCategoryId == -1L) {
            return;
        }
        List categories = this.mbCategoryPersistence.findByG_P(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBCategory category : categories) {
            this._mergeCategories(category, toCategoryId);
        }
        List threads = this._mbThreadPersistence.findByG_C(fromCategory.getGroupId(), fromCategory.getCategoryId());
        for (MBThread thread : threads) {
            thread.setCategoryId(toCategoryId);
            thread = (MBThread)this._mbThreadPersistence.update((BaseModel)thread);
            List messages = this._mbMessagePersistence.findByThreadId(thread.getThreadId());
            for (MBMessage message : messages) {
                message.setCategoryId(toCategoryId);
                message = (MBMessage)this._mbMessagePersistence.update((BaseModel)message);
                this._reindex(MBMessage.class, message);
            }
        }
        this.mbCategoryLocalService.deleteCategory(fromCategory);
    }

    private void _moveDependentsToTrash(User user, List<Object> categoriesAndThreads, long trashEntryId) throws PortalException {
        for (Object object : categoriesAndThreads) {
            MBCategory category;
            int oldStatus;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                oldStatus = thread.getStatus();
                if (oldStatus == 8) continue;
                thread.setStatus(8);
                thread = (MBThread)this._mbThreadPersistence.update((BaseModel)thread);
                if (oldStatus != 0) {
                    this._trashVersionLocalService.addTrashVersion(trashEntryId, MBThread.class.getName(), thread.getThreadId(), oldStatus, null);
                }
                this._mbThreadLocalService.moveDependentsToTrash(thread.getGroupId(), thread.getThreadId(), trashEntryId);
                this._reindex(MBThread.class, thread);
                continue;
            }
            if (!(object instanceof MBCategory) || (category = (MBCategory)object).isInTrash()) continue;
            oldStatus = category.getStatus();
            category.setStatus(8);
            category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
            if (oldStatus != 0) {
                this._trashVersionLocalService.addTrashVersion(trashEntryId, MBCategory.class.getName(), category.getCategoryId(), oldStatus, null);
            }
            this._moveDependentsToTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId()), trashEntryId);
            this._reindex(MBCategory.class, category);
        }
    }

    private <T> void _reindex(Class<T> clazz, T model) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(clazz);
        indexer.reindex(model);
    }

    private void _restoreDependentsFromTrash(User user, List<Object> categoriesAndThreads) throws PortalException {
        for (Object object : categoriesAndThreads) {
            MBCategory category;
            int oldStatus;
            TrashVersion trashVersion;
            if (object instanceof MBThread) {
                MBThread thread = (MBThread)object;
                if (!this._trashHelper.isInTrashImplicitly((TrashedModel)thread)) continue;
                trashVersion = this._trashVersionLocalService.fetchVersion(MBThread.class.getName(), thread.getThreadId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                thread.setStatus(oldStatus);
                thread = (MBThread)this._mbThreadPersistence.update((BaseModel)thread);
                this._mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), thread.getThreadId());
                if (trashVersion != null) {
                    this._trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                this._reindex(MBThread.class, thread);
                continue;
            }
            if (!(object instanceof MBCategory) || !this._trashHelper.isInTrashImplicitly((TrashedModel)(category = (MBCategory)object))) continue;
            trashVersion = this._trashVersionLocalService.fetchVersion(MBCategory.class.getName(), category.getCategoryId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            category.setStatus(oldStatus);
            category = (MBCategory)this.mbCategoryPersistence.update((BaseModel)category);
            this._restoreDependentsFromTrash(user, this.getCategoriesAndThreads(category.getGroupId(), category.getCategoryId(), 8));
            if (trashVersion == null) continue;
            this._trashVersionLocalService.deleteTrashVersion(trashVersion);
        }
    }

    private void _updateChildCategoriesDisplayStyle(MBCategory category, String displayStyle) throws PortalException {
        List<MBCategory> categories = this.getCategories(category.getGroupId(), category.getCategoryId(), -1, -1);
        for (MBCategory curCategory : categories) {
            this._updateChildCategoriesDisplayStyle(curCategory, displayStyle);
            curCategory.setDisplayStyle(displayStyle);
            this.mbCategoryPersistence.update((BaseModel)curCategory);
        }
    }

    private void _validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CategoryNameException("Name is null");
        }
    }
}

