/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.uad.constants.MBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBMessageUADAnonymizer
extends DynamicQueryUADAnonymizer<MBMessage> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected MBMessageLocalService mbMessageLocalService;

    public void autoAnonymize(MBMessage mbMessage, long userId, User anonymousUser) throws PortalException {
        if (mbMessage.getUserId() == userId) {
            mbMessage.setUserId(anonymousUser.getUserId());
            mbMessage.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(mbMessage, anonymousUser);
        }
        if (mbMessage.getStatusByUserId() == userId) {
            mbMessage.setStatusByUserId(anonymousUser.getUserId());
            mbMessage.setStatusByUserName(anonymousUser.getFullName());
        }
        this.mbMessageLocalService.updateMBMessage(mbMessage);
    }

    public void delete(MBMessage mbMessage) throws PortalException {
        this.mbMessageLocalService.deleteMessage(mbMessage);
    }

    public Class<MBMessage> getTypeClass() {
        return MBMessage.class;
    }

    protected void autoAnonymizeAssetEntry(MBMessage mbMessage, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(mbMessage);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.mbMessageLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return MBUADConstants.USER_ID_FIELD_NAMES_MB_MESSAGE;
    }

    protected AssetEntry fetchAssetEntry(MBMessage mbMessage) {
        return this.assetEntryLocalService.fetchEntry(MBMessage.class.getName(), mbMessage.getMessageId());
    }
}

