/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Assignment;
import freemarker.core.AssignmentInstruction;
import freemarker.core.Comment;
import freemarker.core.Environment;
import freemarker.core.LibraryLoad;
import freemarker.core.Macro;
import freemarker.core.ParameterRole;
import freemarker.core.PropertySetting;
import freemarker.core.TemplateElement;
import freemarker.core.TrimInstruction;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

public final class TextBlock
extends TemplateElement {
    private static final String EMPTY_STRING = "";
    static final TextBlock EMPTY_BLOCK = new TextBlock("", false);
    private String text;
    private final boolean unparsed;

    public TextBlock(String text) {
        this(text, false);
    }

    public TextBlock(String text, boolean unparsed) {
        this.text = text;
        this.unparsed = unparsed;
    }

    @Override
    public void accept(Environment env) throws IOException {
        env.getOut().write(this.text);
    }

    @Override
    protected String dump(boolean canonical) {
        if (canonical) {
            String text = new String(this.text);
            if (this.unparsed) {
                return "<#noparse>" + text + "</#noparse>";
            }
            return text;
        }
        return "text " + StringUtil.jQuote(new String(this.text));
    }

    @Override
    String getNodeTypeSymbol() {
        return "#text";
    }

    @Override
    int getParameterCount() {
        return 1;
    }

    @Override
    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.text);
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.CONTENT;
    }

    @Override
    TemplateElement postParseCleanup(boolean stripWhitespace) {
        if (this.text.isEmpty()) {
            return this;
        }
        int openingCharsToStrip = 0;
        int trailingCharsToStrip = 0;
        boolean deliberateLeftTrim = this.deliberateLeftTrim();
        boolean deliberateRightTrim = this.deliberateRightTrim();
        if (!stripWhitespace || this.text.isEmpty()) {
            return this;
        }
        if (this.getParentElement().getParentElement() == null && this.previousSibling() == null) {
            return this;
        }
        if (!deliberateLeftTrim) {
            trailingCharsToStrip = this.trailingCharsToStrip();
        }
        if (!deliberateRightTrim) {
            openingCharsToStrip = this.openingCharsToStrip();
        }
        if (openingCharsToStrip == 0 && trailingCharsToStrip == 0) {
            return this;
        }
        this.text = this.text.substring(openingCharsToStrip, this.text.length() - trailingCharsToStrip);
        if (openingCharsToStrip > 0) {
            ++this.beginLine;
            this.beginColumn = 1;
        }
        if (trailingCharsToStrip > 0) {
            this.endColumn = 0;
        }
        return this;
    }

    private boolean deliberateLeftTrim() {
        boolean result = false;
        for (TemplateElement elem = this.nextTerminalNode(); elem != null && elem.beginLine == this.endLine; elem = elem.nextTerminalNode()) {
            if (!(elem instanceof TrimInstruction)) continue;
            TrimInstruction ti = (TrimInstruction)elem;
            if (!ti.left && !ti.right) {
                result = true;
            }
            if (!ti.left) continue;
            result = true;
            int lastNewLineIndex = this.lastNewLineIndex();
            if (lastNewLineIndex < 0 && this.beginColumn != 1) continue;
            String firstPart = this.text.substring(0, lastNewLineIndex + 1);
            String lastLine = this.text.substring(1 + lastNewLineIndex);
            if (TextBlock.isTrimmableToEmpty(lastLine)) {
                this.text = firstPart;
                this.endColumn = 0;
                continue;
            }
            int i = 0;
            while (Character.isWhitespace(lastLine.charAt(i))) {
                ++i;
            }
            String printablePart = lastLine.substring(i);
            this.text = firstPart.concat(printablePart);
        }
        return result;
    }

    private boolean deliberateRightTrim() {
        boolean result = false;
        for (TemplateElement elem = this.prevTerminalNode(); elem != null && elem.endLine == this.beginLine; elem = elem.prevTerminalNode()) {
            if (!(elem instanceof TrimInstruction)) continue;
            TrimInstruction ti = (TrimInstruction)elem;
            if (!ti.left && !ti.right) {
                result = true;
            }
            if (!ti.right) continue;
            result = true;
            int firstLineIndex = this.firstNewLineIndex() + 1;
            if (firstLineIndex == 0) {
                return false;
            }
            if (this.text.length() > firstLineIndex && this.text.charAt(firstLineIndex - 1) == '\r' && this.text.charAt(firstLineIndex) == '\n') {
                ++firstLineIndex;
            }
            String trailingPart = this.text.substring(firstLineIndex);
            String openingPart = this.text.substring(0, firstLineIndex);
            if (TextBlock.isTrimmableToEmpty(openingPart)) {
                this.text = trailingPart;
                ++this.beginLine;
                this.beginColumn = 1;
                continue;
            }
            int lastNonWS = openingPart.length() - 1;
            while (Character.isWhitespace(this.text.charAt(lastNonWS))) {
                --lastNonWS;
            }
            String printablePart = this.text.substring(0, lastNonWS + 1);
            if (TextBlock.isTrimmableToEmpty(trailingPart)) {
                boolean trimTrailingPart = true;
                for (TemplateElement te = this.nextTerminalNode(); te != null && te.beginLine == this.endLine; te = te.nextTerminalNode()) {
                    if (te.heedsOpeningWhitespace()) {
                        trimTrailingPart = false;
                    }
                    if (!(te instanceof TrimInstruction) || !((TrimInstruction)te).left) continue;
                    trimTrailingPart = true;
                    break;
                }
                if (trimTrailingPart) {
                    trailingPart = EMPTY_STRING;
                }
            }
            this.text = printablePart.concat(trailingPart);
        }
        return result;
    }

    private int firstNewLineIndex() {
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    private int lastNewLineIndex() {
        for (int i = this.text.length() - 1; i >= 0; --i) {
            char c = this.text.charAt(i);
            if (c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    private int openingCharsToStrip() {
        int newlineIndex = this.firstNewLineIndex();
        if (newlineIndex == -1 && this.beginColumn != 1) {
            return 0;
        }
        if (this.text.length() > ++newlineIndex && newlineIndex > 0 && this.text.charAt(newlineIndex - 1) == '\r' && this.text.charAt(newlineIndex) == '\n') {
            ++newlineIndex;
        }
        if (!TextBlock.isTrimmableToEmpty(this.text, 0, newlineIndex)) {
            return 0;
        }
        for (TemplateElement elem = this.prevTerminalNode(); elem != null && elem.endLine == this.beginLine; elem = elem.prevTerminalNode()) {
            if (!elem.heedsOpeningWhitespace()) continue;
            return 0;
        }
        return newlineIndex;
    }

    private int trailingCharsToStrip() {
        int lastNewlineIndex = this.lastNewLineIndex();
        if (lastNewlineIndex == -1 && this.beginColumn != 1) {
            return 0;
        }
        if (!TextBlock.isTrimmableToEmpty(this.text, lastNewlineIndex + 1)) {
            return 0;
        }
        for (TemplateElement elem = this.nextTerminalNode(); elem != null && elem.beginLine == this.endLine; elem = elem.nextTerminalNode()) {
            if (!elem.heedsTrailingWhitespace()) continue;
            return 0;
        }
        return this.text.length() - (lastNewlineIndex + 1);
    }

    @Override
    boolean heedsTrailingWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    @Override
    boolean heedsOpeningWhitespace() {
        if (this.isIgnorable()) {
            return false;
        }
        for (int i = this.text.length() - 1; i >= 0; --i) {
            char c = this.text.charAt(i);
            if (c == '\n' || c == '\r') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return true;
    }

    @Override
    boolean isIgnorable() {
        if (this.text == null || this.text.isEmpty()) {
            return true;
        }
        if (!TextBlock.isTrimmableToEmpty(this.text)) {
            return false;
        }
        boolean atTopLevel = this.getParentElement().getParentElement() == null;
        TemplateElement prevSibling = this.previousSibling();
        TemplateElement nextSibling = this.nextSibling();
        return (prevSibling == null && atTopLevel || this.nonOutputtingType(prevSibling)) && (nextSibling == null && atTopLevel || this.nonOutputtingType(nextSibling));
    }

    private boolean nonOutputtingType(TemplateElement element) {
        return element instanceof Macro || element instanceof Assignment || element instanceof AssignmentInstruction || element instanceof PropertySetting || element instanceof LibraryLoad || element instanceof Comment;
    }

    @Override
    boolean isOutputCacheable() {
        return true;
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }

    private static boolean isTrimmableToEmpty(String text) {
        return TextBlock.isTrimmableToEmpty(text, 0, text.length());
    }

    private static boolean isTrimmableToEmpty(String text, int start) {
        return TextBlock.isTrimmableToEmpty(text, start, text.length());
    }

    private static boolean isTrimmableToEmpty(String text, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (text.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }
}

