/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.notifications.uad.constants.NotificationsUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserNotificationDeliveryUADAnonymizer
extends DynamicQueryUADAnonymizer<UserNotificationDelivery> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected UserNotificationDeliveryLocalService userNotificationDeliveryLocalService;

    public void autoAnonymize(UserNotificationDelivery userNotificationDelivery, long userId, User anonymousUser) throws PortalException {
        if (userNotificationDelivery.getUserId() == userId) {
            this.delete(userNotificationDelivery);
            this.autoAnonymizeAssetEntry(userNotificationDelivery, anonymousUser);
        }
    }

    public void delete(UserNotificationDelivery userNotificationDelivery) throws PortalException {
        this.userNotificationDeliveryLocalService.deleteUserNotificationDelivery(userNotificationDelivery);
    }

    public Class<UserNotificationDelivery> getTypeClass() {
        return UserNotificationDelivery.class;
    }

    protected void autoAnonymizeAssetEntry(UserNotificationDelivery userNotificationDelivery, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(userNotificationDelivery);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.userNotificationDeliveryLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return NotificationsUADConstants.USER_ID_FIELD_NAMES_USER_NOTIFICATION_DELIVERY;
    }

    protected AssetEntry fetchAssetEntry(UserNotificationDelivery userNotificationDelivery) {
        return this.assetEntryLocalService.fetchEntry(UserNotificationDelivery.class.getName(), userNotificationDelivery.getUserNotificationDeliveryId());
    }
}

