/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notifications.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.notifications.uad.constants.NotificationsUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the user notification event UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link UserNotificationEventUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseUserNotificationEventUADAnonymizer
	extends DynamicQueryUADAnonymizer<UserNotificationEvent> {

	@Override
	public void autoAnonymize(
			UserNotificationEvent userNotificationEvent, long userId,
			User anonymousUser)
		throws PortalException {

		if (userNotificationEvent.getUserId() == userId) {
			delete(userNotificationEvent);

			autoAnonymizeAssetEntry(userNotificationEvent, anonymousUser);
		}
	}

	@Override
	public void delete(UserNotificationEvent userNotificationEvent)
		throws PortalException {

		userNotificationEventLocalService.deleteUserNotificationEvent(
			userNotificationEvent);
	}

	@Override
	public Class<UserNotificationEvent> getTypeClass() {
		return UserNotificationEvent.class;
	}

	protected void autoAnonymizeAssetEntry(
		UserNotificationEvent userNotificationEvent, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(userNotificationEvent);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return userNotificationEventLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return NotificationsUADConstants.
			USER_ID_FIELD_NAMES_USER_NOTIFICATION_EVENT;
	}

	protected AssetEntry fetchAssetEntry(
		UserNotificationEvent userNotificationEvent) {

		return assetEntryLocalService.fetchEntry(
			UserNotificationEvent.class.getName(),
			userNotificationEvent.getUserNotificationEventId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected UserNotificationEventLocalService
		userNotificationEventLocalService;

}