/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notifications.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.notifications.uad.constants.NotificationsUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserNotificationEventUADAnonymizer
extends DynamicQueryUADAnonymizer<UserNotificationEvent> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected UserNotificationEventLocalService userNotificationEventLocalService;

    public void autoAnonymize(UserNotificationEvent userNotificationEvent, long userId, User anonymousUser) throws PortalException {
        if (userNotificationEvent.getUserId() == userId) {
            this.delete(userNotificationEvent);
            this.autoAnonymizeAssetEntry(userNotificationEvent, anonymousUser);
        }
    }

    public void delete(UserNotificationEvent userNotificationEvent) throws PortalException {
        this.userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent);
    }

    public Class<UserNotificationEvent> getTypeClass() {
        return UserNotificationEvent.class;
    }

    protected void autoAnonymizeAssetEntry(UserNotificationEvent userNotificationEvent, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(userNotificationEvent);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.userNotificationEventLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return NotificationsUADConstants.USER_ID_FIELD_NAMES_USER_NOTIFICATION_EVENT;
    }

    protected AssetEntry fetchAssetEntry(UserNotificationEvent userNotificationEvent) {
        return this.assetEntryLocalService.fetchEntry(UserNotificationEvent.class.getName(), userNotificationEvent.getUserNotificationEventId());
    }
}

