/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2AuthorizationException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class OAuth2AuthorizationLocalServiceUtil {
    private static ServiceTracker<OAuth2AuthorizationLocalService, OAuth2AuthorizationLocalService> _serviceTracker;

    public static OAuth2Authorization addOAuth2Authorization(long companyId, long userId, String userName, long oAuth2ApplicationId, long oAuth2ApplicationScopeAliasesId, String accessTokenContent, Date accessTokenCreateDate, Date accessTokenExpirationDate, String remoteIPInfo, String refreshTokenContent, Date refreshTokenCreateDate, Date refreshTokenExpirationDate) {
        return OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2Authorization(companyId, userId, userName, oAuth2ApplicationId, oAuth2ApplicationScopeAliasesId, accessTokenContent, accessTokenCreateDate, accessTokenExpirationDate, remoteIPInfo, refreshTokenContent, refreshTokenCreateDate, refreshTokenExpirationDate);
    }

    public static OAuth2Authorization addOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        return OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2Authorization(oAuth2Authorization);
    }

    public static void addOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2ScopeGrantOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public static void addOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, OAuth2Authorization oAuth2Authorization) {
        OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2ScopeGrantOAuth2Authorization(oAuth2ScopeGrantId, oAuth2Authorization);
    }

    public static void addOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, List<OAuth2Authorization> oAuth2Authorizations) {
        OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2Authorizations);
    }

    public static void addOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        OAuth2AuthorizationLocalServiceUtil.getService().addOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    public static void clearOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        OAuth2AuthorizationLocalServiceUtil.getService().clearOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public static OAuth2Authorization createOAuth2Authorization(long oAuth2AuthorizationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().createOAuth2Authorization(oAuth2AuthorizationId);
    }

    public static OAuth2Authorization deleteOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        return OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2Authorization(oAuth2AuthorizationId);
    }

    public static OAuth2Authorization deleteOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        return OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2Authorization(oAuth2Authorization);
    }

    public static void deleteOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2ScopeGrantOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public static void deleteOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, OAuth2Authorization oAuth2Authorization) {
        OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2ScopeGrantOAuth2Authorization(oAuth2ScopeGrantId, oAuth2Authorization);
    }

    public static void deleteOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, List<OAuth2Authorization> oAuth2Authorizations) {
        OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2Authorizations);
    }

    public static void deleteOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        OAuth2AuthorizationLocalServiceUtil.getService().deleteOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    public static PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return OAuth2AuthorizationLocalServiceUtil.getService().deletePersistedModel(persistedModel);
    }

    public static DynamicQuery dynamicQuery() {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQuery();
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQuery(dynamicQuery);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return OAuth2AuthorizationLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery, projection);
    }

    public static OAuth2Authorization fetchOAuth2Authorization(long oAuth2AuthorizationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().fetchOAuth2Authorization(oAuth2AuthorizationId);
    }

    public static OAuth2Authorization fetchOAuth2AuthorizationByAccessTokenContent(String accessTokenContent) {
        return OAuth2AuthorizationLocalServiceUtil.getService().fetchOAuth2AuthorizationByAccessTokenContent(accessTokenContent);
    }

    public static OAuth2Authorization fetchOAuth2AuthorizationByRefreshTokenContent(String refreshTokenContent) {
        return OAuth2AuthorizationLocalServiceUtil.getService().fetchOAuth2AuthorizationByRefreshTokenContent(refreshTokenContent);
    }

    public static ActionableDynamicQuery getActionableDynamicQuery() {
        return OAuth2AuthorizationLocalServiceUtil.getService().getActionableDynamicQuery();
    }

    public static IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        return OAuth2AuthorizationLocalServiceUtil.getService().getIndexableActionableDynamicQuery();
    }

    public static OAuth2Authorization getOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2Authorization(oAuth2AuthorizationId);
    }

    public static OAuth2Authorization getOAuth2AuthorizationByAccessTokenContent(String accessTokenContent) throws NoSuchOAuth2AuthorizationException {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2AuthorizationByAccessTokenContent(accessTokenContent);
    }

    public static OAuth2Authorization getOAuth2AuthorizationByRefreshTokenContent(String refreshTokenContent) throws NoSuchOAuth2AuthorizationException {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2AuthorizationByRefreshTokenContent(refreshTokenContent);
    }

    public static List<OAuth2Authorization> getOAuth2Authorizations(int start, int end) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2Authorizations(start, end);
    }

    public static List<OAuth2Authorization> getOAuth2Authorizations(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2Authorizations(oAuth2ApplicationId, start, end, orderByComparator);
    }

    public static int getOAuth2AuthorizationsCount() {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2AuthorizationsCount();
    }

    public static int getOAuth2AuthorizationsCount(long oAuth2ApplicationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2AuthorizationsCount(oAuth2ApplicationId);
    }

    public static List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public static List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, int start, int end) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, start, end);
    }

    public static List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, start, end, orderByComparator);
    }

    public static int getOAuth2ScopeGrantOAuth2AuthorizationsCount(long oAuth2ScopeGrantId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrantOAuth2AuthorizationsCount(oAuth2ScopeGrantId);
    }

    public static long[] getOAuth2ScopeGrantPrimaryKeys(long oAuth2AuthorizationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrantPrimaryKeys(oAuth2AuthorizationId);
    }

    public static Collection<OAuth2ScopeGrant> getOAuth2ScopeGrants(long oAuth2AuthorizationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOAuth2ScopeGrants(oAuth2AuthorizationId);
    }

    public static String getOSGiServiceIdentifier() {
        return OAuth2AuthorizationLocalServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return OAuth2AuthorizationLocalServiceUtil.getService().getPersistedModel(primaryKeyObj);
    }

    public static List<OAuth2Authorization> getUserOAuth2Authorizations(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getUserOAuth2Authorizations(userId, start, end, orderByComparator);
    }

    public static int getUserOAuth2AuthorizationsCount(long userId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().getUserOAuth2AuthorizationsCount(userId);
    }

    public static boolean hasOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().hasOAuth2ScopeGrantOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public static boolean hasOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        return OAuth2AuthorizationLocalServiceUtil.getService().hasOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public static void setOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        OAuth2AuthorizationLocalServiceUtil.getService().setOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    public static OAuth2Authorization updateOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        return OAuth2AuthorizationLocalServiceUtil.getService().updateOAuth2Authorization(oAuth2Authorization);
    }

    public static OAuth2AuthorizationLocalService getService() {
        return (OAuth2AuthorizationLocalService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(OAuth2AuthorizationLocalService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), OAuth2AuthorizationLocalService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

