/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.redirect;

import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class OAuth2RedirectURIInterpolator {
    public static final String TOKEN_PORT_WITH_COLON = "@port-with-colon@";
    public static final String TOKEN_PROTOCOL = "@protocol@";
    private static final String[] _TOKENS = new String[]{"@port-with-colon@", "@protocol@"};

    public static List<String> interpolateRedirectURIsList(HttpServletRequest httpServletRequest, List<String> redirectURIsList, Portal portal) {
        ArrayList<String> interpolattedRedirectURIsList = new ArrayList<String>();
        String protocol = "http";
        boolean secure = false;
        if (httpServletRequest != null) {
            secure = portal.isSecure(httpServletRequest);
        } else if ("https".equals(PropsUtil.get((String)"portal.instance.protocol")) || "https".equals(PropsUtil.get((String)"web.server.protocol"))) {
            secure = true;
        }
        if (secure) {
            protocol = "https";
        }
        String portWithColon = ":" + portal.getPortalLocalPort(secure);
        if (httpServletRequest != null) {
            portWithColon = ":" + portal.getForwardedPort(httpServletRequest);
        }
        if (Objects.equals(portWithColon, ":80")) {
            portWithColon = "";
        }
        if (secure && Objects.equals(portWithColon, ":443")) {
            portWithColon = "";
        }
        for (String redirectURI : redirectURIsList) {
            interpolattedRedirectURIsList.add(StringUtil.replace((String)redirectURI, (String[])_TOKENS, (String[])new String[]{portWithColon, protocol}));
        }
        return interpolattedRedirectURIsList;
    }
}

