/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler.BaseAccessTokenGrantHandler;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.DigestCodeVerifier;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={AccessTokenGrantHandler.class})
public class LiferayAuthorizationAccessTokenCodeGrantHandler
extends BaseAccessTokenGrantHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayAuthorizationAccessTokenCodeGrantHandler.class);
    private AuthorizationCodeGrantHandler _authorizationCodeGrantHandler;
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._authorizationCodeGrantHandler = new AuthorizationCodeGrantHandler();
        this._authorizationCodeGrantHandler.setCodeVerifierTransformer(new DigestCodeVerifier());
        this._authorizationCodeGrantHandler.setDataProvider(this._liferayOAuthDataProvider);
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        this._authorizationCodeGrantHandler.setExpectCodeVerifierForPublicClients(this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant());
    }

    @Override
    protected AccessTokenGrantHandler getAccessTokenGrantHandler() {
        return this._authorizationCodeGrantHandler;
    }

    @Override
    protected boolean hasPermission(Client client, MultivaluedMap<String, String> params) {
        List<String> allowedGrantTypes;
        String code = (String)params.getFirst((Object)"code");
        if (code == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No code parameter was provided");
            }
            return false;
        }
        ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = this._liferayOAuthDataProvider.getServerAuthorizationCodeGrant(code);
        if (serverAuthorizationCodeGrant == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No code grant found for code " + code));
            }
            return false;
        }
        if (!this.clientsMatch(client, serverAuthorizationCodeGrant.getClient())) {
            this._liferayOAuthDataProvider.removeCodeGrant(code);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticated client does not match the code's client");
            }
            return false;
        }
        if (client.isConfidential()) {
            if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodeGrant()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"authorization_code grant is not allowed");
                }
                return false;
            }
            allowedGrantTypes = client.getAllowedGrantTypes();
            if (!allowedGrantTypes.contains("authorization_code")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Client is not allowed to use authorization_code grant");
                }
                return false;
            }
        } else {
            if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"authorization_code with PKCE grant is not allowed");
                }
                return false;
            }
            allowedGrantTypes = client.getAllowedGrantTypes();
            if (!allowedGrantTypes.contains("authorization_code_pkce")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Client is not allowed to use authorization_code with PKCE grant");
                }
                return false;
            }
        }
        OAuth2Application oAuth2Application = this._liferayOAuthDataProvider.resolveOAuth2Application(serverAuthorizationCodeGrant.getClient());
        UserSubject userSubject = serverAuthorizationCodeGrant.getSubject();
        return this.hasCreateTokenPermission(GetterUtil.getLong((String)userSubject.getId()), oAuth2Application);
    }

    @Override
    protected boolean isGrantHandlerEnabled() {
        return this._oAuth2ProviderConfiguration.allowAuthorizationCodeGrant() || this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant();
    }
}

