/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler.BaseAccessTokenGrantHandler;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.grants.clientcred.ClientCredentialsGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={AccessTokenGrantHandler.class})
public class LiferayClientCredentialsAccessTokenGrantHandler
extends BaseAccessTokenGrantHandler {
    private ClientCredentialsGrantHandler _clientCredentialsGrantHandler;
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._clientCredentialsGrantHandler = new ClientCredentialsGrantHandler();
        this._clientCredentialsGrantHandler.setDataProvider(this._liferayOAuthDataProvider);
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
    }

    @Override
    protected AccessTokenGrantHandler getAccessTokenGrantHandler() {
        return this._clientCredentialsGrantHandler;
    }

    @Override
    protected boolean hasPermission(Client client, MultivaluedMap<String, String> params) {
        OAuth2Application oAuth2Application = this._liferayOAuthDataProvider.resolveOAuth2Application(client);
        return this.hasCreateTokenPermission(oAuth2Application.getClientCredentialUserId(), oAuth2Application);
    }

    @Override
    protected boolean isGrantHandlerEnabled() {
        return this._oAuth2ProviderConfiguration.allowClientCredentialsGrant();
    }
}

