/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import java.net.URI;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AuthorizationCodeGrantService;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, immediate=true, service={})
public class AuthorizationCodeGrantServiceRegistrator {
    private static final Log _log = LogFactoryUtil.getLog(AuthorizationCodeGrantServiceRegistrator.class);
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private ServiceRegistration<Object> _serviceRegistration;
    @Reference
    private SubjectCreator _subjectCreator;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        OAuth2ProviderConfiguration oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        if (!oAuth2ProviderConfiguration.allowAuthorizationCodeGrant() && !oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant()) {
            return;
        }
        LiferayAuthorizationCodeGrantService authorizationCodeGrantService = new LiferayAuthorizationCodeGrantService();
        authorizationCodeGrantService.setCanSupportPublicClients(oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant());
        authorizationCodeGrantService.setDataProvider(this._liferayOAuthDataProvider);
        authorizationCodeGrantService.setSubjectCreator(this._subjectCreator);
        this._serviceRegistration = bundleContext.registerService(Object.class, (Object)authorizationCodeGrantService, (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)"(osgi.jaxrs.name=Liferay.OAuth2.Application)").put((Object)"osgi.jaxrs.name", (Object)"Liferay.Authorization.Code.Grant.Service").put((Object)"osgi.jaxrs.resource", (Object)true).build());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private static String _getCookieName(String clientId) {
        return "OAUTH2_REMEMBER_DEVICE_".concat(clientId);
    }

    public static class LiferayAuthorizationCodeGrantService
    extends AuthorizationCodeGrantService {
        @Context
        private UriInfo _uriInfo;

        @Override
        public ServerAuthorizationCodeGrant getGrantRepresentation(OAuthRedirectionState oAuthRedirectionState, Client client, List<String> requestedScopesList, List<String> approvedScopesList, UserSubject userSubject, ServerAccessToken serverAccessToken) {
            ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = super.getGrantRepresentation(oAuthRedirectionState, client, requestedScopesList, approvedScopesList, userSubject, serverAccessToken);
            String cookieName = AuthorizationCodeGrantServiceRegistrator._getCookieName(client.getClientId());
            String rememberDeviceContent = this._getRememberDeviceContent(cookieName);
            if (rememberDeviceContent == null) {
                return serverAuthorizationCodeGrant;
            }
            long userId = GetterUtil.getLong((String)userSubject.getId());
            LiferayOAuthDataProvider liferayOAuthDataProvider = this._getLiferayOAuthDataProvider();
            OAuth2Authorization oAuth2Authorization = liferayOAuthDataProvider.getOAuth2Authorization(client, rememberDeviceContent, userId);
            if (oAuth2Authorization == null || !rememberDeviceContent.equals(oAuth2Authorization.getRememberDeviceContent())) {
                return serverAuthorizationCodeGrant;
            }
            liferayOAuthDataProvider.doRevokeAuthorization(oAuth2Authorization);
            Cookie cookie = this._getCookie(cookieName);
            MessageContext messageContext = this.getMessageContext();
            CookieKeys.addCookie((HttpServletRequest)messageContext.getHttpServletRequest(), (HttpServletResponse)messageContext.getHttpServletResponse(), (Cookie)cookie);
            Map<String, String> extraProperties = serverAuthorizationCodeGrant.getExtraProperties();
            extraProperties.put("oauth2.remember.device", cookie.getValue());
            return serverAuthorizationCodeGrant;
        }

        @Override
        protected boolean canAuthorizationBeSkipped(MultivaluedMap<String, String> params, Client client, UserSubject userSubject, List<String> requestedScopesList, List<OAuthPermission> permissions) {
            RefreshToken refreshToken;
            if (MapUtil.getBoolean(client.getProperties(), (String)"trusted.application")) {
                return true;
            }
            if (!MapUtil.getBoolean(client.getProperties(), (String)"remember.device")) {
                return super.canAuthorizationBeSkipped(params, client, userSubject, requestedScopesList, permissions);
            }
            String rememberDeviceContent = this._getRememberDeviceContent(AuthorizationCodeGrantServiceRegistrator._getCookieName(client.getClientId()));
            if (rememberDeviceContent == null) {
                return super.canAuthorizationBeSkipped(params, client, userSubject, requestedScopesList, permissions);
            }
            long userId = GetterUtil.getLong((String)userSubject.getId());
            LiferayOAuthDataProvider liferayOAuthDataProvider = this._getLiferayOAuthDataProvider();
            OAuth2Authorization oAuth2Authorization = liferayOAuthDataProvider.getOAuth2Authorization(client, rememberDeviceContent, userId);
            if (oAuth2Authorization != null && rememberDeviceContent.equals(oAuth2Authorization.getRememberDeviceContent()) && (refreshToken = liferayOAuthDataProvider.getRefreshToken(oAuth2Authorization.getRefreshTokenContent())) != null && !OAuthUtils.isExpired(refreshToken.getIssuedAt(), refreshToken.getExpiresIn())) {
                return true;
            }
            return super.canAuthorizationBeSkipped(params, client, userSubject, requestedScopesList, permissions);
        }

        @Override
        protected Response deliverOOBResponse(OOBAuthorizationResponse oobAuthorizationResponse) {
            _log.error((Object)("The parameter \"redirect_uri\" was not found in the request for client " + oobAuthorizationResponse.getClientId()));
            return Response.status((int)500).build();
        }

        @Override
        protected Client getClient(String clientId, MultivaluedMap<String, String> params) {
            block4: {
                try {
                    Client client = this.getValidClient(clientId, params);
                    if (client != null) {
                        return client;
                    }
                }
                catch (OAuthServiceException oAuthServiceException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Unable to validate remote client", (Throwable)oAuthServiceException);
                    }
                    if (oAuthServiceException.getError() == null) break block4;
                    this.reportInvalidRequestError(oAuthServiceException.getError(), null);
                }
            }
            this.reportInvalidRequestError(new OAuthError("invalid_client"), null);
            return null;
        }

        @Override
        protected OAuthRedirectionState recreateRedirectionStateFromParams(MultivaluedMap<String, String> params) {
            OAuthRedirectionState oAuthRedirectionState = super.recreateRedirectionStateFromParams(params);
            LiferayOAuthDataProvider liferayOAuthDataProvider = this._getLiferayOAuthDataProvider();
            Client client = liferayOAuthDataProvider.getClient(oAuthRedirectionState.getClientId());
            if (!MapUtil.getBoolean(client.getProperties(), (String)"remember.device") || !params.containsKey((Object)"_com_liferay_oauth2_provider_web_internal_portlet_OAuth2AuthorizePortlet_rememberDevice")) {
                return oAuthRedirectionState;
            }
            Cookie cookie = this._getCookie(AuthorizationCodeGrantServiceRegistrator._getCookieName(client.getClientId()));
            MessageContext messageContext = this.getMessageContext();
            CookieKeys.addCookie((HttpServletRequest)messageContext.getHttpServletRequest(), (HttpServletResponse)messageContext.getHttpServletResponse(), (Cookie)cookie);
            Map<String, String> extraProperties = oAuthRedirectionState.getExtraProperties();
            extraProperties.put("oauth2.remember.device", cookie.getValue());
            return oAuthRedirectionState;
        }

        private Cookie _getCookie(String cookieName) {
            UUID uuid = new UUID(SecureRandomUtil.nextLong(), SecureRandomUtil.nextLong());
            Cookie cookie = new Cookie(cookieName, uuid.toString());
            URI uri = this._uriInfo.getBaseUri();
            cookie.setPath(uri.getPath());
            return cookie;
        }

        private LiferayOAuthDataProvider _getLiferayOAuthDataProvider() {
            return (LiferayOAuthDataProvider)this.getDataProvider();
        }

        private String _getRememberDeviceContent(String cookieName) {
            MessageContext messageContext = this.getMessageContext();
            HttpServletRequest httpServletRequest = messageContext.getHttpServletRequest();
            return Stream.of(httpServletRequest.getCookies()).filter(cookie -> Objects.equals(cookie.getName(), cookieName)).map(Cookie::getValue).findFirst().orElse(null);
        }
    }
}

