/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize.container.request.filter;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.configuration.AuthorizeScreenConfiguration;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URI;
import java.security.Principal;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.security.SecurityContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@PreMatching
@Priority(value=1000)
@Provider
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=AuthorizationCodeGrantServiceContainerRequestFilter"}, service={ContainerRequestFilter.class})
public class AuthorizationCodeGrantServiceContainerRequestFilter
implements ContainerRequestFilter {
    private static final Log _log = LogFactoryUtil.getLog(AuthorizationCodeGrantServiceContainerRequestFilter.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference(target="(model.class.name=com.liferay.oauth2.provider.model.OAuth2Application)")
    private ModelResourcePermission<OAuth2Application> _oAuth2ApplicationModelResourcePermission;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void filter(ContainerRequestContext containerRequestContext) {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        if (!StringUtil.startsWith((String)uriInfo.getPath(), (String)"authorize")) {
            return;
        }
        try {
            String clientId;
            User user = this._portal.getUser(this._httpServletRequest);
            if (user == null) {
                user = this._userLocalService.getDefaultUser(this._portal.getCompanyId(this._httpServletRequest));
            }
            boolean guestAuthorized = false;
            if (user.isDefaultUser() && !Validator.isBlank((String)(clientId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"client_id")))) {
                guestAuthorized = this._containsOAuth2ApplicationViewPermission(clientId, user);
            }
            if (!user.isDefaultUser() || guestAuthorized) {
                final long userId = user.getUserId();
                containerRequestContext.setSecurityContext((javax.ws.rs.core.SecurityContext)new PortalCXFSecurityContext(){

                    public Principal getUserPrincipal() {
                        return new ProtectedPrincipal(String.valueOf(userId));
                    }

                    public boolean isSecure() {
                        return AuthorizationCodeGrantServiceContainerRequestFilter.this._portal.isSecure(AuthorizationCodeGrantServiceContainerRequestFilter.this._httpServletRequest);
                    }
                });
                return;
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to resolve authenticated user", (Throwable)exception);
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            return;
        }
        String loginURL = null;
        try {
            loginURL = this._getLoginURL();
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to locate configuration", (Throwable)configurationException);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        URI requestURI = uriInfo.getRequestUri();
        String requestURIString = requestURI.toASCIIString();
        String portalURL = this._portal.getPortalURL(this._httpServletRequest);
        if (requestURIString.startsWith(portalURL)) {
            requestURIString = requestURIString.substring(portalURL.length());
        }
        requestURIString = requestURIString.replaceFirst("\\?.*", StringUtil.replace((String)("?" + requestURI.getRawQuery()), (char)':', (String)"%3a"));
        loginURL = HttpComponentsUtil.addParameter((String)loginURL, (String)"redirect", (String)requestURIString);
        containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.FOUND).location(URI.create(loginURL)).build());
    }

    private boolean _containsOAuth2ApplicationViewPermission(String clientId, User user) throws Exception {
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(user.getCompanyId(), clientId);
        if (oAuth2Application == null) {
            return false;
        }
        return this._oAuth2ApplicationModelResourcePermission.contains(this._permissionCheckerFactory.create(user), (ClassedModel)oAuth2Application, "VIEW");
    }

    private String _getLoginURL() throws ConfigurationException {
        AuthorizeScreenConfiguration authorizeScreenConfiguration = (AuthorizeScreenConfiguration)this._configurationProvider.getConfiguration(AuthorizeScreenConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(this._portal.getCompanyId(this._httpServletRequest), AuthorizeScreenConfiguration.class.getName()));
        String loginURL = authorizeScreenConfiguration.loginURL();
        if (Validator.isBlank((String)loginURL)) {
            loginURL = StringBundler.concat((String[])new String[]{this._portal.getPortalURL(this._httpServletRequest), this._portal.getPathContext(), this._portal.getPathMain(), "/portal/login"});
        } else if (!HttpComponentsUtil.hasDomain((String)loginURL)) {
            String portalURL = this._portal.getPortalURL(this._httpServletRequest);
            loginURL = portalURL + loginURL;
        }
        return loginURL;
    }

    private static abstract class PortalCXFSecurityContext
    implements SecurityContext,
    javax.ws.rs.core.SecurityContext {
        private PortalCXFSecurityContext() {
        }

        public String getAuthenticationScheme() {
            return "session";
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

