/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.CollectionScopeFinder;
import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.RequiresScopeAnnotationFinder;
import com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter.BaseScopeCheckerContainerRequestFilter;
import com.liferay.oauth2.provider.scope.RequiresNoScope;
import com.liferay.oauth2.provider.scope.RequiresScope;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.petra.string.StringBundler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Provider
@Component(property={"osgi.jaxrs.application.select=(|(oauth2.scope.checker.type=annotations)(oauth2.scopechecker.type=annotations))", "osgi.jaxrs.extension=true", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.OAuth2)", "osgi.jaxrs.name=Liferay.OAuth2.annotations.feature"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class AnnotationFeature
implements Feature {
    private BundleContext _bundleContext;
    @Reference
    private ScopeChecker _scopeChecker;
    private ServiceRegistration<ScopeFinder> _serviceRegistration;

    public boolean configure(FeatureContext context) {
        Configuration configuration = context.getConfiguration();
        HashSet<String> scopes = new HashSet<String>();
        context.register((resourceInfo, a) -> scopes.addAll(RequiresScopeAnnotationFinder.find(resourceInfo.getResourceClass())));
        context.register((Object)new AnnotationContainerScopeCheckerContainerRequestFilter(), 1992);
        Map applicationProperties = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
        this._serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)new CollectionScopeFinder(scopes), new Hashtable(applicationProperties));
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class AnnotationContainerScopeCheckerContainerRequestFilter
    extends BaseScopeCheckerContainerRequestFilter {
        @Context
        private ResourceInfo _resourceInfo;

        private AnnotationContainerScopeCheckerContainerRequestFilter() {
        }

        public boolean isContainerRequestContextAllowed(ContainerRequestContext containerRequestContext) {
            Method resourceMethod = this._resourceInfo.getResourceMethod();
            RequiresNoScope requiresNoScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceMethod, RequiresNoScope.class);
            RequiresScope requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceMethod, RequiresScope.class);
            if (requiresNoScope != null && requiresScope != null) {
                StringBundler sb = new StringBundler(6);
                Class<?> declaringClass = resourceMethod.getDeclaringClass();
                sb.append("Method ");
                sb.append(declaringClass.getName());
                sb.append("#");
                sb.append(resourceMethod.getName());
                sb.append("has both @RequiresNoScope and @RequiresScope ");
                sb.append("annotations defined");
                throw new RuntimeException(sb.toString());
            }
            if (requiresNoScope != null || this.checkRequiresScope(requiresScope)) {
                return true;
            }
            Class resourceClass = this._resourceInfo.getResourceClass();
            requiresNoScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceClass, RequiresNoScope.class);
            requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceClass, RequiresScope.class);
            if (requiresNoScope != null && requiresScope != null) {
                throw new RuntimeException(StringBundler.concat((String[])new String[]{"Class ", resourceClass.getName(), "has both @RequiresNoScope and @RequiresScope ", "annotations defined"}));
            }
            return requiresNoScope != null || this.checkRequiresScope(requiresScope);
        }

        protected boolean checkRequiresScope(RequiresScope requiresScope) {
            if (requiresScope != null) {
                if (requiresScope.allNeeded()) {
                    return AnnotationFeature.this._scopeChecker.checkAllScopes(requiresScope.value());
                }
                return AnnotationFeature.this._scopeChecker.checkAnyScope(requiresScope.value());
            }
            return false;
        }
    }
}

