/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.scope.RequiresScope;
import com.liferay.petra.reflect.AnnotationLocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

public class RequiresScopeAnnotationFinder {
    public static Collection<String> find(Class<?> clazz) {
        HashSet<String> scopes = new HashSet<String>();
        RequiresScopeAnnotationFinder._find(new HashSet(), scopes, true, clazz);
        return scopes;
    }

    public static <T extends Annotation> T getScopeAnnotation(AnnotatedElement annotatedElement, Class<T> annotationClass) {
        T t = annotatedElement.getAnnotation(annotationClass);
        if (t != null) {
            return t;
        }
        List annotations = Collections.emptyList();
        if (annotatedElement instanceof Class) {
            annotations = AnnotationLocator.locate((Class)((Class)annotatedElement));
        } else if (annotatedElement instanceof Method) {
            annotations = AnnotationLocator.locate((Method)((Method)annotatedElement), null);
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> curAnnotationClass = annotation.annotationType();
            if (curAnnotationClass.equals(annotationClass)) {
                return (T)annotation;
            }
            t = curAnnotationClass.getAnnotation(annotationClass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private static void _find(Set<Class<?>> classes, Set<String> scopes, boolean recurse, Class<?> clazz) {
        RequiresScope requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(clazz, RequiresScope.class);
        if (requiresScope != null) {
            Collections.addAll(scopes, requiresScope.value());
        }
        Stream<Method> stream = Arrays.stream(clazz.getMethods());
        List methods = stream.filter(RequiresScopeAnnotationFinder::_isAnnotatedMethod).collect(Collectors.toList());
        for (Method method : methods) {
            RequiresScopeAnnotationFinder._find(classes, scopes, recurse, method);
        }
        classes.remove(clazz);
    }

    private static void _find(Set<Class<?>> visited, Set<String> scopes, boolean recurse, Method method) {
        RequiresScope requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(method, RequiresScope.class);
        if (requiresScope != null) {
            Collections.addAll(scopes, requiresScope.value());
        }
        if (RequiresScopeAnnotationFinder._isSubresourceLocator(method) && recurse) {
            RequiresScopeAnnotationFinder._find(visited, scopes, false, method.getReturnType());
        }
    }

    private static boolean _isAnnotatedMethod(Method method) {
        List annotations = AnnotationLocator.locate((Method)method, Path.class);
        return !annotations.isEmpty() || RequiresScopeAnnotationFinder._isHttpMethod(method);
    }

    private static boolean _isHttpMethod(Method method) {
        List annotations = AnnotationLocator.locate((Method)method, null);
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.getAnnotationsByType(HttpMethod.class) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean _isSubresourceLocator(Method method) {
        return method.getDeclaredAnnotation(Path.class) != null || !RequiresScopeAnnotationFinder._isHttpMethod(method);
    }
}

