/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs.multipart;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.ext.multipart.MultipartOutputFilter;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.rs.security.jose.jaxrs.multipart.JwsMultipartSignatureOutFilter;
import org.apache.cxf.rs.security.jose.jws.JwsDetachedSignature;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public abstract class AbstractJwsMultipartSignatureFilter {
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();
    private JwsSignatureProvider sigProvider;
    private boolean useJwsJsonSignatureFormat;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected List<Object> getAttachmentParts(Object rootEntity) {
        List<Object> parts = null;
        if (rootEntity instanceof MultipartBody) {
            parts = CastUtils.cast((List)((MultipartBody)rootEntity).getAllAttachments());
        } else {
            parts = new ArrayList();
            if (rootEntity instanceof List) {
                List entityList = CastUtils.cast((List)((List)rootEntity));
                parts.addAll(entityList);
            } else {
                parts.add(rootEntity);
            }
        }
        JwsHeaders headers = new JwsHeaders();
        headers.setPayloadEncodingStatus(false);
        JwsSignatureProvider theSigProvider = this.sigProvider != null ? this.sigProvider : JwsUtils.loadSignatureProvider(headers, true);
        JwsSignature jwsSignature = theSigProvider.createJwsSignature(headers);
        String base64UrlEncodedHeaders = Base64UrlUtility.encode((String)this.writer.toJson(headers));
        byte[] headerBytesWithDot = StringUtils.toBytesASCII((String)(base64UrlEncodedHeaders + "."));
        jwsSignature.update(headerBytesWithDot, 0, headerBytesWithDot.length);
        AttachmentUtils.addMultipartOutFilter((MultipartOutputFilter)new JwsMultipartSignatureOutFilter(jwsSignature));
        JwsDetachedSignature jws = new JwsDetachedSignature(headers, base64UrlEncodedHeaders, jwsSignature, this.useJwsJsonSignatureFormat);
        Attachment jwsPart = new Attachment("signature", "application/jose", (Object)jws);
        parts.add(jwsPart);
        return parts;
    }

    public void setUseJwsJsonSignatureFormat(boolean useJwsJsonSignatureFormat) {
        this.useJwsJsonSignatureFormat = useJwsJsonSignatureFormat;
    }
}

