/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.configuration;

import com.liferay.oauth2.provider.rest.internal.configuration.OAuth2AuthorizationServerConfiguration;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.io.IOException;
import java.util.Dictionary;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class OAuth2AuthorizationServerConfigurationGenerator {
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    @Activate
    protected void activate() throws IOException {
        Configuration configuration = this._configurationAdmin.getConfiguration(OAuth2AuthorizationServerConfiguration.class.getName(), "?");
        Dictionary dictionary = configuration.getProperties();
        if (dictionary != null) {
            return;
        }
        configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"oauth2.authorization.server.issue.jwt.access.token", (Object)true).put((Object)"oauth2.authorization.server.jwt.access.token.signing.json.web.key", () -> {
            RsaJsonWebKey rsaJsonWebKey = RsaJwkGenerator.generateJwk((int)2048);
            rsaJsonWebKey.setAlgorithm("RS256");
            rsaJsonWebKey.setKeyId("authServer");
            return rsaJsonWebKey.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        }).build());
    }
}

