/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.configuration.admin.service;

import com.liferay.oauth2.provider.rest.internal.configuration.OAuth2InAssertionConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.pid=com.liferay.oauth2.provider.rest.internal.configuration.OAuth2InAssertionConfiguration"}, service={ManagedServiceFactory.class, OAuth2InAssertionManagedServiceFactory.class})
public class OAuth2InAssertionManagedServiceFactory
implements ManagedServiceFactory {
    private static final Log _log = LogFactoryUtil.getLog(OAuth2InAssertionManagedServiceFactory.class);
    private final Map<String, Dictionary<String, ?>> _configurationPidsProperties = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Long, Map<String, Map<String, JwsSignatureVerifier>>> _jwsSignatureVerifiers = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<Long, Map<String, String>> _userAuthTypes = Collections.synchronizedMap(new LinkedHashMap());

    public void deleted(String pid) {
        Dictionary<String, ?> properties = this._configurationPidsProperties.remove(pid);
        long companyId = GetterUtil.getLong(properties.get("companyId"));
        if (companyId == 0L) {
            this._rebuild();
        } else {
            this._rebuild(companyId);
        }
    }

    public JwsSignatureVerifier getJWSSignatureVerifier(long companyId, String issuer, String kid) throws IllegalArgumentException {
        StringBundler sb = new StringBundler(12);
        Map<String, Map<String, JwsSignatureVerifier>> jwsSignatureVerifiers = this._jwsSignatureVerifiers.getOrDefault(companyId, this._jwsSignatureVerifiers.get(0L));
        if (jwsSignatureVerifiers == null) {
            sb.append("No JWS signature keys in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        Map<String, JwsSignatureVerifier> kidsJWSSignatureVerifiers = jwsSignatureVerifiers.get(issuer);
        if (kidsJWSSignatureVerifiers == null) {
            sb.append("No JWS signature keys for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        if (!kidsJWSSignatureVerifiers.containsKey(kid)) {
            sb.append("No JWS signature key of kid: ");
            sb.append(kid);
            sb.append(", for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        return kidsJWSSignatureVerifiers.get(kid);
    }

    public String getName() {
        return "";
    }

    public String getUserAuthType(long companyId, String issuer) throws IllegalArgumentException {
        StringBundler sb = new StringBundler(6);
        Map<String, String> userAuthTypes = this._userAuthTypes.getOrDefault(companyId, this._userAuthTypes.get(0L));
        if (userAuthTypes == null) {
            sb.append("No user auth types in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        if (!userAuthTypes.containsKey(issuer)) {
            sb.append("No user auth type for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        return userAuthTypes.get(issuer);
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        Dictionary<String, ?> oldProperties = this._configurationPidsProperties.put(pid, properties);
        long companyId = GetterUtil.getLong(properties.get("companyId"), (long)0L);
        if (companyId == 0L) {
            this._rebuild();
            return;
        }
        if (oldProperties != null) {
            long oldCompanyId = GetterUtil.getLong(oldProperties.get("companyId"));
            if (oldCompanyId == 0L) {
                this._rebuild();
                return;
            }
            if (oldCompanyId != companyId) {
                this._rebuild(oldCompanyId);
            }
        }
        this._rebuild(companyId);
    }

    @Activate
    protected void activate() {
        this._jwsSignatureVerifiers.put(0L, Collections.emptyMap());
        this._userAuthTypes.put(0L, Collections.emptyMap());
    }

    private <U, V> void _addDefaults(Map<U, V> map, Map<U, V> defaultsMap) {
        if (defaultsMap != null) {
            defaultsMap.forEach(map::putIfAbsent);
        }
    }

    private void _rebuild() {
        this._rebuild(0L);
        for (Long key : this._jwsSignatureVerifiers.keySet()) {
            if (key == 0L) continue;
            this._rebuild(key);
        }
    }

    private void _rebuild(long companyId) {
        HashMap jwsSignatureVerifiers = new HashMap();
        HashMap<String, String> userAuthTypes = new HashMap<String, String>();
        for (Dictionary<String, ?> properties : this._configurationPidsProperties.values()) {
            if (companyId != GetterUtil.getLong(properties.get("companyId"))) continue;
            OAuth2InAssertionConfiguration oAuth2InAssertionConfiguration = (OAuth2InAssertionConfiguration)ConfigurableUtil.createConfigurable(OAuth2InAssertionConfiguration.class, properties);
            String issuer = oAuth2InAssertionConfiguration.issuer();
            if (jwsSignatureVerifiers.containsKey(issuer)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Duplicate issuer name ", issuer, " will be ", "discarded. Check your OAuth configuration."}));
                continue;
            }
            jwsSignatureVerifiers.put(issuer, new HashMap());
            userAuthTypes.put(issuer, oAuth2InAssertionConfiguration.userAuthType());
            Map kidsJWSSignatureVerifiers = (Map)jwsSignatureVerifiers.get(issuer);
            JsonWebKeys jsonWebKeys = JwkUtils.readJwkSet(oAuth2InAssertionConfiguration.signatureJSONWebKeySet());
            for (JsonWebKey jsonWebKey : jsonWebKeys.getKeys()) {
                PublicKeyUse publicKeyUse = jsonWebKey.getPublicKeyUse();
                if (publicKeyUse != null && publicKeyUse.compareTo(PublicKeyUse.ENCRYPT) == 0) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Encryption key " + jsonWebKey.getKeyId()));
                    continue;
                }
                if (kidsJWSSignatureVerifiers.containsKey(jsonWebKey.getKeyId())) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Duplicate assertion signature key ", jsonWebKey.getKeyId(), " will be discarded. Check your OAuth ", "configuration."}));
                    continue;
                }
                kidsJWSSignatureVerifiers.put(jsonWebKey.getKeyId(), JwsUtils.getSignatureVerifier(jsonWebKey));
            }
        }
        if (companyId != 0L) {
            this._addDefaults(jwsSignatureVerifiers, this._jwsSignatureVerifiers.get(0L));
            this._addDefaults(userAuthTypes, this._userAuthTypes.get(0L));
        }
        this._jwsSignatureVerifiers.put(companyId, jwsSignatureVerifiers);
        this._userAuthTypes.put(companyId, userAuthTypes);
    }
}

