/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token;

import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.remote.cors.annotation.CORS;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.services.AccessTokenService;

@Path(value="/token")
public class LiferayAccessTokenService
extends AccessTokenService {
    private static final Log _log = LogFactoryUtil.getLog(LiferayAccessTokenService.class);

    @Override
    @Consumes(value={"application/x-www-form-urlencoded"})
    @CORS(allowMethods={"POST"})
    @POST
    @Produces(value={"application/json"})
    public Response handleTokenRequest(MultivaluedMap<String, String> params) {
        ClientAccessToken clientAccessToken;
        Map<String, String> parameters;
        Response response = super.handleTokenRequest(params);
        if (Response.Status.OK.getStatusCode() == response.getStatus() && (parameters = (clientAccessToken = (ClientAccessToken)response.readEntity(ClientAccessToken.class)).getParameters()).containsKey("oauth2.remember.device")) {
            LiferayOAuthDataProvider liferayOAuthDataProvider = (LiferayOAuthDataProvider)this.getDataProvider();
            liferayOAuthDataProvider.updateRememberDeviceContent(clientAccessToken.getRefreshToken(), parameters.get("oauth2.remember.device"));
        }
        return response;
    }

    @Override
    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        String remoteHost;
        String remoteAddr;
        Map<String, String> properties;
        Client client;
        block4: {
            String clientSecret;
            String clientId = (String)params.getFirst((Object)"client_id");
            if (clientId != null && clientId.isEmpty()) {
                this.reportInvalidClient();
            }
            if ((clientSecret = (String)params.getFirst((Object)"client_secret")) != null && clientSecret.isEmpty()) {
                params.remove((Object)"client_secret");
            }
            client = super.authenticateClientIfNeeded(params);
            properties = client.getProperties();
            MessageContext messageContext = this.getMessageContext();
            HttpServletRequest httpServletRequest = messageContext.getHttpServletRequest();
            remoteAddr = httpServletRequest.getRemoteAddr();
            remoteHost = httpServletRequest.getRemoteHost();
            try {
                InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)remoteAddr);
                remoteHost = inetAddress.getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)unknownHostException);
            }
        }
        properties.put("client.remote.addr", remoteAddr);
        properties.put("client.remote.host", remoteHost);
        return client;
    }

    @Override
    protected void injectContextIntoOAuthProviders() {
    }
}

