/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.rest.internal.configuration.admin.service.OAuth2InAssertionManagedServiceFactory;
import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler.BaseAccessTokenGrantHandler;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.jwt.JwtBearerGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={AccessTokenGrantHandler.class})
public class LiferayJWTBearerGrantHandler
extends BaseAccessTokenGrantHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJWTBearerGrantHandler.class);
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    @Reference
    private OAuth2InAssertionManagedServiceFactory _oAuth2InAssertionManagedServiceFactory;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    @Override
    public List<String> getSupportedGrantTypes() {
        AccessTokenGrantHandler accessTokenGrantHandler = this._getAccessTokenGrantHandler();
        return accessTokenGrantHandler.getSupportedGrantTypes();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(Client client, MultivaluedMap<String, String> params) {
        AccessTokenGrantHandler accessTokenGrantHandler = this._getAccessTokenGrantHandler();
        return accessTokenGrantHandler.createAccessToken(client, params);
    }

    @Override
    protected boolean hasPermission(Client client, MultivaluedMap<String, String> multivaluedMap) {
        return multivaluedMap.getFirst((Object)"assertion") != null;
    }

    @Override
    protected boolean isGrantHandlerEnabled() {
        return this._oAuth2ProviderConfiguration.allowJWTBearerGrant();
    }

    private AccessTokenGrantHandler _getAccessTokenGrantHandler() {
        CustomJWTBearerGrantHandler customJWTBearerGrantHandler = new CustomJWTBearerGrantHandler();
        customJWTBearerGrantHandler.setDataProvider(this._liferayOAuthDataProvider);
        return customJWTBearerGrantHandler;
    }

    private class CustomJWTBearerGrantHandler
    extends JwtBearerGrantHandler {
        private CustomJWTBearerGrantHandler() {
        }

        @Override
        public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> multivaluedMap) throws OAuthServiceException {
            String assertion = (String)multivaluedMap.getFirst((Object)"assertion");
            Map<String, String> clientProperties = client.getProperties();
            long companyId = GetterUtil.getLong((String)clientProperties.get("company.id"));
            try {
                JwsJwtCompactConsumer jwsJwtCompactConsumer = this.getJwsReader(assertion);
                JwtToken jwtToken = jwsJwtCompactConsumer.getJwtToken();
                JwtClaims jwtClaims = jwtToken.getClaims();
                JwsHeaders jwsHeaders = jwtToken.getJwsHeaders();
                this._initGrantHandler(companyId, jwtClaims, jwsHeaders);
                this.validateSignature(new JwsHeaders(jwsHeaders), jwsJwtCompactConsumer.getUnsignedEncodedSequence(), jwsJwtCompactConsumer.getDecodedSignature());
                this.validateClaims(client, jwtClaims);
                return this.doCreateAccessToken(client, this._createUserSubject(companyId, jwtClaims.getIssuer(), jwtClaims.getSubject()), "urn:ietf:params:oauth:grant-type:jwt-bearer", OAuthUtils.parseScope((String)multivaluedMap.getFirst((Object)"scope")));
            }
            catch (Exception exception) {
                throw new OAuthServiceException(exception);
            }
        }

        private UserSubject _createUserSubject(long companyId, String issuer, String subject) {
            String userAuthType = null;
            try {
                userAuthType = LiferayJWTBearerGrantHandler.this._oAuth2InAssertionManagedServiceFactory.getUserAuthType(companyId, issuer);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)illegalArgumentException);
                }
                throw new OAuthServiceException("invalid_grant");
            }
            UserSubject userSubject = new UserSubject("");
            if (userAuthType.equals("userId")) {
                userSubject.setId(subject);
                return userSubject;
            }
            Map<String, String> properties = userSubject.getProperties();
            properties.put("company.id", String.valueOf(companyId));
            properties.put(userAuthType, subject);
            return userSubject;
        }

        private void _initGrantHandler(long companyId, JwtClaims jwtClaims, JwsHeaders jwsHeaders) {
            JwsSignatureVerifier jwsSignatureVerifier = null;
            try {
                jwsSignatureVerifier = LiferayJWTBearerGrantHandler.this._oAuth2InAssertionManagedServiceFactory.getJWSSignatureVerifier(companyId, jwtClaims.getIssuer(), jwsHeaders.getKeyId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)illegalArgumentException);
                }
                throw new OAuthServiceException("invalid_grant");
            }
            this.setJwsVerifier(jwsSignatureVerifier);
        }
    }
}

