/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.authorize.message.body;

import com.liferay.oauth2.provider.rest.internal.endpoint.authorize.message.body.BaseMessageBodyWriter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Produces(value={"text/html"})
@Provider
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=OAuthAuthorizationDataMessageBodyWriter"}, service={MessageBodyWriter.class})
public class OAuthAuthorizationDataMessageBodyWriter
extends BaseMessageBodyWriter<OAuthAuthorizationData> {
    private int _invokerFilterURIMaxLength = 4000;
    @Reference
    private Props _props;

    public boolean isWriteable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return clazz.isAssignableFrom(OAuthAuthorizationData.class) && StringUtil.equalsIgnoreCase((String)mediaType.getType(), (String)"text") && StringUtil.equalsIgnoreCase((String)mediaType.getSubtype(), (String)"html");
    }

    @Activate
    protected void activate() {
        this._invokerFilterURIMaxLength = GetterUtil.getInteger((String)this._props.get("invoker.filter.uri.max.length"), (int)this._invokerFilterURIMaxLength);
    }

    @Override
    protected String writeTo(OAuthAuthorizationData oAuthAuthorizationData, String authorizeScreenURL) {
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "code_challenge", oAuthAuthorizationData.getClientCodeChallenge());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "audience", oAuthAuthorizationData.getAudience());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "client_id", oAuthAuthorizationData.getClientId());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "nonce", oAuthAuthorizationData.getNonce());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "redirect_uri", oAuthAuthorizationData.getRedirectUri());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "response_type", oAuthAuthorizationData.getResponseType());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "scope", oAuthAuthorizationData.getProposedScope());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "session_authenticity_token", oAuthAuthorizationData.getAuthenticityToken());
        authorizeScreenURL = this.setParameter(authorizeScreenURL, "state", oAuthAuthorizationData.getState());
        if ((authorizeScreenURL = this.setParameter(authorizeScreenURL, "reply_to", this._getReplyTo(oAuthAuthorizationData))).length() > this._invokerFilterURIMaxLength) {
            authorizeScreenURL = this.removeParameter(authorizeScreenURL, "scope");
        }
        return authorizeScreenURL;
    }

    private String _getReplyTo(OAuthAuthorizationData oAuthAuthorizationData) {
        if (this.portal.isForwardedSecure(this.messageContext.getHttpServletRequest())) {
            UriInfo uriInfo = this.messageContext.getUriInfo();
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
            uriBuilder.path("decision");
            uriBuilder.scheme("https");
            URI uri = uriBuilder.build(new Object[0]);
            return uri.toString();
        }
        return oAuthAuthorizationData.getReplyTo();
    }
}

