/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.liferay;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.security.Principal;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SubjectCreator.class})
public class LiferaySubjectCreator
implements SubjectCreator {
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public UserSubject createUserSubject(MessageContext messageContext, MultivaluedMap<String, String> params) throws OAuthServiceException {
        SecurityContext securityContext = messageContext.getSecurityContext();
        Principal userPrincipal = securityContext.getUserPrincipal();
        try {
            User user = this._userLocalService.getUser(GetterUtil.getLong((String)userPrincipal.getName()));
            UserSubject userSubject = new UserSubject(user.getLogin(), String.valueOf(user.getUserId()));
            Map<String, String> properties = userSubject.getProperties();
            properties.put("company.id", String.valueOf(user.getCompanyId()));
            return userSubject;
        }
        catch (PortalException portalException) {
            throw new OAuthServiceException(portalException);
        }
    }
}

