/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.liferay;

import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"timeout:Integer=15"}, service={ServerAuthorizationCodeGrantProvider.class})
public class ServerAuthorizationCodeGrantProvider {
    private static final Log _log = LogFactoryUtil.getLog(ServerAuthorizationCodeGrantProvider.class);
    private static final MethodKey _getServerAuthorizationCodeGrantMethodKey = new MethodKey(ServerAuthorizationCodeGrantProvider.class, "_getServerAuthorizationCodeGrant", new Class[]{String.class});
    private static final MethodKey _getServerAuthorizationCodeGrantsMethodKey = new MethodKey(ServerAuthorizationCodeGrantProvider.class, "_getServerAuthorizationCodeGrants", new Class[]{String.class});
    private static final MethodKey _putServerAuthorizationCodeGrantMethodKey = new MethodKey(ServerAuthorizationCodeGrantProvider.class, "_putServerAuthorizationCodeGrant", new Class[]{ServerAuthorizationCodeGrant.class});
    private static final MethodKey _removeServerAuthorizationCodeGrantMethodMethodKey = new MethodKey(ServerAuthorizationCodeGrantProvider.class, "_removeServerAuthorizationCodeGrant", new Class[]{String.class});
    private static final DelayQueue<ServerAuthorizationCodeGrantDelayed> _serverAuthorizationCodeGrantDelayeds = new DelayQueue();
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    private int _timeout;

    public ServerAuthorizationCodeGrant getServerAuthorizationCodeGrant(String code) {
        if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
            return ServerAuthorizationCodeGrantProvider._getServerAuthorizationCodeGrant(code);
        }
        NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(new MethodHandler(_getServerAuthorizationCodeGrantMethodKey, new Object[]{code}));
        try {
            return (ServerAuthorizationCodeGrant)future.get(this._timeout, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            _log.error((Object)"Timeout getting code grant from master node", (Throwable)exception);
            return null;
        }
    }

    public List<ServerAuthorizationCodeGrant> getServerAuthorizationCodeGrants(Client client, UserSubject userSubject) {
        if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
            return ServerAuthorizationCodeGrantProvider._getServerAuthorizationCodeGrants(client, userSubject);
        }
        NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(new MethodHandler(_getServerAuthorizationCodeGrantsMethodKey, new Object[]{client, userSubject}));
        try {
            return (List)future.get(this._timeout, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            _log.error((Object)"Timeout getting code grants from master node", (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public void putServerAuthorizationCodeGrant(ServerAuthorizationCodeGrant serverAuthorizationCodeGrant) {
        if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
            ServerAuthorizationCodeGrantProvider._putServerAuthorizationCodeGrant(serverAuthorizationCodeGrant);
        } else {
            NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(new MethodHandler(_putServerAuthorizationCodeGrantMethodKey, new Object[]{serverAuthorizationCodeGrant}));
            try {
                future.get(this._timeout, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                _log.error((Object)"Timeout setting code grant to master node", (Throwable)exception);
            }
        }
    }

    public ServerAuthorizationCodeGrant removeServerAuthorizationCodeGrant(String code) {
        if (!this._clusterMasterExecutor.isEnabled() || this._clusterMasterExecutor.isMaster()) {
            return ServerAuthorizationCodeGrantProvider._removeServerAuthorizationCodeGrant(code);
        }
        NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(new MethodHandler(_removeServerAuthorizationCodeGrantMethodMethodKey, new Object[]{code}));
        try {
            return (ServerAuthorizationCodeGrant)future.get(this._timeout, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            _log.error((Object)"Timeout removing code grant from master node", (Throwable)exception);
            return null;
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._timeout = MapUtil.getInteger(properties, (String)"timeout");
    }

    private static void _cleanUp() {
        while (_serverAuthorizationCodeGrantDelayeds.poll() != null) {
        }
    }

    private static ServerAuthorizationCodeGrant _getServerAuthorizationCodeGrant(String code) {
        ServerAuthorizationCodeGrantProvider._cleanUp();
        for (ServerAuthorizationCodeGrantDelayed serverAuthorizationCodeGrantDelayed : _serverAuthorizationCodeGrantDelayeds) {
            ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = serverAuthorizationCodeGrantDelayed.getServerAuthorizationCodeGrant();
            if (!code.equals(serverAuthorizationCodeGrant.getCode())) continue;
            return serverAuthorizationCodeGrant;
        }
        return null;
    }

    private static List<ServerAuthorizationCodeGrant> _getServerAuthorizationCodeGrants(Client client, UserSubject userSubject) {
        ServerAuthorizationCodeGrantProvider._cleanUp();
        ArrayList<ServerAuthorizationCodeGrant> serverAuthorizationCodeGrants = new ArrayList<ServerAuthorizationCodeGrant>();
        for (ServerAuthorizationCodeGrantDelayed serverAuthorizationCodeGrantDelayed : _serverAuthorizationCodeGrantDelayeds) {
            ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = serverAuthorizationCodeGrantDelayed.getServerAuthorizationCodeGrant();
            if (!client.equals(serverAuthorizationCodeGrant.getClient()) || !userSubject.equals(serverAuthorizationCodeGrant.getSubject())) continue;
            serverAuthorizationCodeGrants.add(serverAuthorizationCodeGrant);
        }
        return serverAuthorizationCodeGrants;
    }

    private static void _putServerAuthorizationCodeGrant(ServerAuthorizationCodeGrant serverAuthorizationCodeGrant) {
        ServerAuthorizationCodeGrantProvider._cleanUp();
        _serverAuthorizationCodeGrantDelayeds.add(new ServerAuthorizationCodeGrantDelayed(serverAuthorizationCodeGrant));
    }

    private static ServerAuthorizationCodeGrant _removeServerAuthorizationCodeGrant(String code) {
        ServerAuthorizationCodeGrantProvider._cleanUp();
        AtomicReference serverAuthorizationCodeGrantAtomicReference = new AtomicReference();
        _serverAuthorizationCodeGrantDelayeds.removeIf(serverAuthorizationCodeGrantDelayed -> {
            ServerAuthorizationCodeGrant serverAuthorizationCodeGrant = serverAuthorizationCodeGrantDelayed.getServerAuthorizationCodeGrant();
            if (code.equals(serverAuthorizationCodeGrant.getCode())) {
                serverAuthorizationCodeGrantAtomicReference.compareAndSet(null, serverAuthorizationCodeGrant);
                return true;
            }
            return false;
        });
        return (ServerAuthorizationCodeGrant)serverAuthorizationCodeGrantAtomicReference.get();
    }

    private static class ServerAuthorizationCodeGrantDelayed
    implements Delayed {
        private static final Comparator<ServerAuthorizationCodeGrantDelayed> _comparator = Comparator.comparing(ServerAuthorizationCodeGrantDelayed::_getExpirationTime);
        private final ServerAuthorizationCodeGrant _serverAuthorizationCodeGrant;

        public ServerAuthorizationCodeGrantDelayed(ServerAuthorizationCodeGrant serverAuthorizationCodeGrant) {
            this._serverAuthorizationCodeGrant = serverAuthorizationCodeGrant;
        }

        @Override
        public int compareTo(Delayed delayed) {
            return _comparator.compare(this, (ServerAuthorizationCodeGrantDelayed)delayed);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long expirationTime = TimeUnit.MILLISECONDS.convert(this._getExpirationTime(), TimeUnit.SECONDS);
            return unit.convert(expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public ServerAuthorizationCodeGrant getServerAuthorizationCodeGrant() {
            return this._serverAuthorizationCodeGrant;
        }

        private long _getExpirationTime() {
            return this._serverAuthorizationCodeGrant.getIssuedAt() + this._serverAuthorizationCodeGrant.getExpiresIn();
        }
    }
}

