/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.CollectionScopeFinder;
import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.RequiresScopeAnnotationFinder;
import com.liferay.oauth2.provider.rest.internal.scope.logic.ScopeLogic;
import com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter.BaseScopeCheckerContainerRequestFilter;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Provider
@Component(property={"osgi.jaxrs.application.select=(|(oauth2.scope.checker.type=annotations)(oauth2.scopechecker.type=annotations))", "osgi.jaxrs.extension=true", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.OAuth2)", "osgi.jaxrs.name=Liferay.OAuth2.annotations.feature"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class AnnotationFeature
implements Feature {
    private BundleContext _bundleContext;
    private Function<String, Object> _propertyAccessorFunction;
    @Reference
    private ScopeChecker _scopeChecker;
    @Reference(target="(oauth2.scope.checker.type=annotations)")
    private ScopeLogic _scopeLogic;
    private ServiceRegistration<ScopeFinder> _serviceRegistration;

    public boolean configure(FeatureContext featureContext1) {
        HashSet<String> scopes = new HashSet<String>();
        featureContext1.register((resourceInfo, featureContext2) -> scopes.addAll(RequiresScopeAnnotationFinder.find(resourceInfo.getResourceClass())));
        featureContext1.register((Object)new AnnotationContainerScopeCheckerContainerRequestFilter(), 1992);
        Configuration configuration = featureContext1.getConfiguration();
        Map applicationProperties = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
        this._propertyAccessorFunction = applicationProperties::get;
        this._serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)new CollectionScopeFinder(scopes), new Hashtable(applicationProperties));
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private class AnnotationContainerScopeCheckerContainerRequestFilter
    extends BaseScopeCheckerContainerRequestFilter {
        @Context
        private ResourceInfo _resourceInfo;

        private AnnotationContainerScopeCheckerContainerRequestFilter() {
        }

        public boolean isContainerRequestContextAllowed(ContainerRequestContext containerRequestContext) {
            return AnnotationFeature.this._scopeLogic.check(AnnotationFeature.this._propertyAccessorFunction, this._resourceInfo.getResourceClass(), this._resourceInfo.getResourceMethod(), AnnotationFeature.this._scopeChecker);
        }
    }
}

