/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.vulcan.graphql.validation;

import com.liferay.oauth2.provider.rest.internal.scope.logic.ScopeLogic;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.liferay.OAuth2ProviderScopeLiferayAccessControlContext;
import com.liferay.oauth2.provider.scope.liferay.ScopeContext;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicy;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.security.access.control.AccessControlAdvisorImpl;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContext;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContextValidator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.Application;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={GraphQLRequestContextValidator.class})
public class OAuth2GraphQLRequestContextValidator
implements GraphQLRequestContextValidator {
    private static final AccessControlled _NULL_ACCESS_CONTROLLED = new AccessControlled(){

        public Class<? extends Annotation> annotationType() {
            return AccessControlled.class;
        }

        public boolean guestAccessEnabled() {
            return false;
        }

        public boolean hostAllowedValidationEnabled() {
            return false;
        }
    };
    private final AccessControlAdvisor _accessControlAdvisor = new AccessControlAdvisorImpl();
    private BundleContext _bundleContext;
    @Reference
    private ScopeChecker _scopeChecker;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ScopeContext _scopeContext;

    public void validate(GraphQLRequestContext graphQLRequestContext) throws Exception {
        if (!graphQLRequestContext.isJaxRsResourceInvocation()) {
            return;
        }
        if (OAuth2ProviderScopeLiferayAccessControlContext.isOAuth2AuthVerified()) {
            ServiceReference<?> serviceReference = this._getServiceReference(graphQLRequestContext.getApplicationName());
            this._enableSAP(serviceReference);
            this._checkScope(graphQLRequestContext, serviceReference);
        }
        this._setServiceDepth();
        this._accessControlAdvisor.accept(graphQLRequestContext.getResourceMethod(), new Object[0], _NULL_ACCESS_CONTROLLED);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private void _checkScope(GraphQLRequestContext graphQLRequestContext, ServiceReference<?> applicationServiceReference) throws Exception {
        String scopeSheckerType = this._getProperty(null, "oauth2.scope.checker.type", applicationServiceReference);
        if (scopeSheckerType == null) {
            scopeSheckerType = this._getProperty("http.method", "oauth2.scope.checker.type", applicationServiceReference);
        }
        Collection serviceReferences = this._bundleContext.getServiceReferences(ScopeLogic.class, "(oauth2.scope.checker.type=" + scopeSheckerType + ")");
        this._scopeContext.setApplicationName(graphQLRequestContext.getApplicationName());
        this._scopeContext.setBundle(FrameworkUtil.getBundle((Class)graphQLRequestContext.getResourceClass()));
        this._scopeContext.setCompanyId(graphQLRequestContext.getCompanyId());
        try {
            if (serviceReferences.isEmpty()) {
                throw new ForbiddenException();
            }
            for (ServiceReference serviceReference : serviceReferences) {
                ScopeLogic scopeLogic = (ScopeLogic)this._bundleContext.getService(serviceReference);
                if (scopeLogic.check(arg_0 -> applicationServiceReference.getProperty(arg_0), graphQLRequestContext.getResourceClass(), graphQLRequestContext.getResourceMethod(), this._scopeChecker)) continue;
                throw new ForbiddenException();
            }
        }
        catch (Exception exception) {
            throw new ForbiddenException((Throwable)exception);
        }
        finally {
            this._scopeContext.setApplicationName(null);
            this._scopeContext.setBundle(null);
            this._scopeContext.setCompanyId(0L);
        }
    }

    private void _enableSAP(ServiceReference<?> serviceReference) throws Exception {
        String policyName;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
        if (authVerifierResult == null) {
            return;
        }
        Map settings = authVerifierResult.getSettings();
        List serviceAccessPolicyNames = (List)settings.computeIfAbsent(ServiceAccessPolicy.SERVICE_ACCESS_POLICY_NAMES, value -> new ArrayList());
        if (!serviceAccessPolicyNames.contains(policyName = this._getProperty("AUTHORIZED_OAUTH2_SAP", "oauth2.service.access.policy.name", serviceReference))) {
            serviceAccessPolicyNames.add(policyName);
        }
    }

    private String _getProperty(String defaultValue, String propertyName, ServiceReference<?> serviceReference) {
        String propertyValue = (String)serviceReference.getProperty(propertyName);
        if (Validator.isBlank((String)propertyValue)) {
            return defaultValue;
        }
        return propertyValue;
    }

    private ServiceReference<?> _getServiceReference(String applicationName) throws Exception {
        List serviceReferences = (List)this._bundleContext.getServiceReferences(Application.class, "(osgi.jaxrs.name=" + applicationName + ")");
        if (ListUtil.isNotEmpty((List)serviceReferences)) {
            return (ServiceReference)serviceReferences.get(0);
        }
        throw new UnsupportedOperationException("Invalid JAX-RS application " + applicationName);
    }

    private void _setServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), 1);
    }
}

