/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jws.JwsDetachedSignature;

public class JwsDetachedSignatureProvider
implements MessageBodyWriter<JwsDetachedSignature> {
    public long getSize(JwsDetachedSignature arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return true;
    }

    public void writeTo(JwsDetachedSignature parts, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        JoseUtils.traceHeaders(parts.getHeaders());
        byte[] finalBytes = parts.getSignature().sign();
        if (!parts.isUseJwsJsonSignatureFormat()) {
            os.write(StringUtils.toBytesASCII((String)parts.getEncodedHeaders()));
            byte[] dotBytes = new byte[]{46};
            os.write(dotBytes);
            os.write(dotBytes);
            Base64UrlUtility.encodeAndStream((byte[])finalBytes, (int)0, (int)finalBytes.length, (OutputStream)os);
        } else {
            os.write(StringUtils.toBytesASCII((String)"{"));
            String headersProp = "\"protected\":\"" + parts.getEncodedHeaders() + "\"";
            os.write(StringUtils.toBytesUTF8((String)headersProp));
            os.write(StringUtils.toBytesASCII((String)","));
            String sigProp = "\"signature\":\"" + Base64UrlUtility.encode((byte[])finalBytes) + "\"";
            os.write(StringUtils.toBytesUTF8((String)sigProp));
            os.write(StringUtils.toBytesASCII((String)"}"));
        }
    }
}

