/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class AesGcmWrapKeyEncryptionAlgorithm
extends AbstractWrapKeyEncryptionAlgorithm {
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList(KeyAlgorithm.A128GCMKW.getJwaName(), KeyAlgorithm.A192GCMKW.getJwaName(), KeyAlgorithm.A256GCMKW.getJwaName()));

    public AesGcmWrapKeyEncryptionAlgorithm(String encodedKey, KeyAlgorithm keyAlgoJwt) {
        this(CryptoUtils.decodeSequence(encodedKey), keyAlgoJwt);
    }

    public AesGcmWrapKeyEncryptionAlgorithm(byte[] keyBytes, KeyAlgorithm keyAlgoJwt) {
        this(CryptoUtils.createSecretKeySpec(keyBytes, "AES"), keyAlgoJwt);
    }

    public AesGcmWrapKeyEncryptionAlgorithm(SecretKey key, KeyAlgorithm keyAlgoJwt) {
        super(key, keyAlgoJwt, true, SUPPORTED_ALGORITHMS);
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        byte[] wrappedKeyAndTag = super.getEncryptedContentEncryptionKey(headers, cek);
        byte[] wrappedKey = new byte[wrappedKeyAndTag.length - 16];
        System.arraycopy(wrappedKeyAndTag, 0, wrappedKey, 0, wrappedKeyAndTag.length - 16);
        String encodedTag = Base64UrlUtility.encodeChunk((byte[])wrappedKeyAndTag, (int)(wrappedKeyAndTag.length - 16), (int)16);
        headers.setHeader("tag", encodedTag);
        Arrays.fill(wrappedKeyAndTag, (byte)0);
        return wrappedKey;
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweHeaders headers) {
        byte[] iv = CryptoUtils.generateSecureRandomBytes(12);
        String encodedIv = Base64UrlUtility.encode((byte[])iv);
        headers.setHeader("iv", encodedIv);
        return CryptoUtils.getContentEncryptionCipherSpec(128, iv);
    }
}

