/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.Collections;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.json.basic.JsonObject;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonSignatureEntry
implements JsonObject {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonSignatureEntry.class);
    private final String jwsPayload;
    private final String encodedProtectedHeader;
    private final String encodedSignature;
    private final JwsHeaders protectedHeader;
    private final JwsHeaders unprotectedHeader;
    private JwsHeaders unionHeaders;
    private final JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();

    public JwsJsonSignatureEntry(String jwsPayload, String encodedProtectedHeader, String encodedSignature, JwsHeaders unprotectedHeader) {
        if (encodedProtectedHeader == null && unprotectedHeader == null || encodedSignature == null) {
            LOG.warning("Invalid Signature entry");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        this.jwsPayload = jwsPayload;
        this.encodedProtectedHeader = encodedProtectedHeader;
        this.encodedSignature = encodedSignature;
        this.unprotectedHeader = unprotectedHeader;
        this.protectedHeader = encodedProtectedHeader != null ? new JwsHeaders(this.writer.fromJson(JoseUtils.decodeToString(encodedProtectedHeader))) : null;
        this.prepare();
    }

    private void prepare() {
        this.unionHeaders = new JwsHeaders();
        if (this.protectedHeader != null) {
            this.unionHeaders.asMap().putAll(this.protectedHeader.asMap());
        }
        if (this.unprotectedHeader != null) {
            if (!Collections.disjoint(this.unionHeaders.asMap().keySet(), this.unprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            this.unionHeaders.asMap().putAll(this.unprotectedHeader.asMap());
        }
    }

    public String getJwsPayload() {
        return this.jwsPayload;
    }

    public String getDecodedJwsPayload() {
        if (this.protectedHeader == null || !JwsUtils.isPayloadUnencoded(this.protectedHeader)) {
            return JoseUtils.decodeToString(this.jwsPayload);
        }
        return this.jwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public String getEncodedProtectedHeader() {
        return this.encodedProtectedHeader;
    }

    public JwsHeaders getProtectedHeader() {
        return this.protectedHeader;
    }

    public JwsHeaders getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    public JwsHeaders getUnionHeader() {
        return this.unionHeaders;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public byte[] getDecodedSignature() {
        return JoseUtils.decode(this.getEncodedSignature());
    }

    public String getUnsignedSequence() {
        if (this.getEncodedProtectedHeader() != null) {
            return this.getEncodedProtectedHeader() + "." + this.getJwsPayload();
        }
        return "." + this.getJwsPayload();
    }

    public String getKeyId() {
        return this.getUnionHeader().getKeyId();
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getUnionHeader(), this.getUnsignedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (JwsException jwsException) {
            // empty catch block
        }
        LOG.warning("Invalid Signature Entry");
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean validateCriticalHeaders() {
        if (this.getUnprotectedHeader().getHeader("crit") != null) {
            return false;
        }
        return JwsUtils.validateCriticalHeaders(this.getUnionHeader());
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean flattenedMode) {
        StringBuilder sb = new StringBuilder(32);
        if (!flattenedMode) {
            sb.append('{');
        }
        if (this.protectedHeader != null) {
            sb.append("\"protected\":\"").append(Base64UrlUtility.encode((String)this.writer.toJson(this.protectedHeader))).append('\"');
        }
        if (this.unprotectedHeader != null) {
            if (this.protectedHeader != null) {
                sb.append(',');
            }
            sb.append("\"header\":").append(this.writer.toJson(this.unprotectedHeader));
        }
        sb.append(',');
        sb.append("\"signature\":\"").append(this.encodedSignature).append('\"');
        if (!flattenedMode) {
            sb.append('}');
        }
        return sb.toString();
    }
}

