/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.client.ClientCodeStateManager;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public class MemoryClientCodeStateManager
implements ClientCodeStateManager {
    private Map<String, MultivaluedMap<String, String>> map = new ConcurrentHashMap<String, MultivaluedMap<String, String>>();
    private boolean generateNonce;

    @Override
    public MultivaluedMap<String, String> toRedirectState(MessageContext mc, MultivaluedMap<String, String> requestState) {
        String stateParam = OAuthUtils.generateRandomTokenKey();
        MetadataMap redirectMap = new MetadataMap();
        if (this.generateNonce) {
            String nonceParam = MessageDigestUtils.generate(CryptoUtils.generateSecureRandomBytes(32));
            requestState.putSingle((Object)"nonce", (Object)nonceParam);
            redirectMap.putSingle((Object)"nonce", (Object)nonceParam);
        }
        this.map.put(stateParam, requestState);
        OAuthUtils.setSessionToken(mc, stateParam, "state", 0);
        redirectMap.putSingle((Object)"state", (Object)stateParam);
        return redirectMap;
    }

    @Override
    public MultivaluedMap<String, String> fromRedirectState(MessageContext mc, MultivaluedMap<String, String> redirectState) {
        String stateParam = (String)redirectState.getFirst((Object)"state");
        String sessionToken = OAuthUtils.getSessionToken(mc, "state");
        if (sessionToken == null || !sessionToken.equals(stateParam)) {
            throw new OAuthServiceException("Invalid session token");
        }
        return this.map.remove(stateParam);
    }

    public void setGenerateNonce(boolean generateNonce) {
        this.generateNonce = generateNonce;
    }
}

