/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.provider.ClientSecretVerifier;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public class ClientSecretHashVerifier
implements ClientSecretVerifier {
    private String hashAlgorithm = "SHA-256";

    @Override
    public boolean validateClientSecret(Client client, String clientSecret) {
        String hash = MessageDigestUtils.generate(StringUtils.toBytesUTF8((String)clientSecret), this.hashAlgorithm);
        return hash.equals(client.getClientSecret());
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }
}

