/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.authentication.handler;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.grants.jwt.JwtBearerAuthHandler;
import org.apache.cxf.rs.security.oauth2.provider.ClientRegistrationProvider;
import org.apache.cxf.security.SecurityContext;

@Provider
public class LiferayJWTBearerAuthenticationHandler
extends JwtBearerAuthHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJWTBearerAuthenticationHandler.class);
    private ClientRegistrationProvider _clientRegistrationProvider;

    @Override
    public void filter(ContainerRequestContext containerRequestContext) {
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        if (!StringUtil.startsWith((String)uriInfo.getPath(), (String)"token")) {
            return;
        }
        Message message = JAXRSUtils.getCurrentMessage();
        HttpServletRequest httpServletRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (!this._isUsingJWTAssertionForClientAuthentication(httpServletRequest)) {
            return;
        }
        String assertion = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"client_assertion");
        if (assertion == null) {
            throw new NotAuthorizedException((Object)"Missing JWT assertion", new Object[0]);
        }
        JwtToken jwtToken = super.getJwtToken(assertion);
        String claimSubject = (String)jwtToken.getClaim("sub");
        String clientId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"client_id");
        if (Validator.isNotNull((String)clientId) && !clientId.equals(claimSubject)) {
            throw new NotAuthorizedException((Object)"Client ID parameter does not match JWT subject", new Object[0]);
        }
        message.put((Object)"client_id", (Object)claimSubject);
        SecurityContext securityContext = this.configureSecurityContext(jwtToken);
        if (securityContext != null) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)securityContext);
        }
    }

    public void setClientRegistrationProvider(ClientRegistrationProvider clientRegistrationProvider) {
        this._clientRegistrationProvider = clientRegistrationProvider;
    }

    @Override
    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwtToken jwtToken) {
        Client client = this._clientRegistrationProvider.getClient((String)jwtToken.getClaim("sub"));
        String tokenEndpointAuthMethod = client.getTokenEndpointAuthMethod();
        try {
            if (tokenEndpointAuthMethod.equals("client_secret_jwt")) {
                return new HmacJwsSignatureVerifier(client.getClientSecret());
            }
            if (tokenEndpointAuthMethod.equals("private_key_jwt")) {
                Map<String, String> clientProperties = client.getProperties();
                JsonWebKeys jsonWebKeys = JwkUtils.readJwkSet(clientProperties.get("jwks"));
                return JwsUtils.getSignatureVerifier(jsonWebKeys.getKey((String)jwtToken.getJwsHeader("kid")));
            }
            throw new IllegalArgumentException("Client is configured to not use JWT as a client authentication method");
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new NotAuthorizedException((Object)"invalid_client", new Object[0]);
        }
    }

    private boolean _isUsingJWTAssertionForClientAuthentication(HttpServletRequest httpServletRequest) {
        String assertionType = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"client_assertion_type");
        if (Validator.isNull((String)assertionType)) {
            return false;
        }
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer".equals(HttpUtils.urlDecode((String)assertionType));
    }
}

