/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAccessTokenGrantHandler
implements AccessTokenGrantHandler {
    @Reference(target="(model.class.name=com.liferay.oauth2.provider.model.OAuth2Application)")
    protected ModelResourcePermission<OAuth2Application> modelResourcePermission;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseAccessTokenGrantHandler.class);

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        if (!this.isGrantHandlerEnabled()) {
            throw new OAuthServiceException("Grant handler is not enabled");
        }
        if (!this.hasPermission(client, params)) {
            throw new OAuthServiceException("User does not have permission to create token");
        }
        return this.doCreateAccessToken(client, params);
    }

    protected boolean clientsMatch(Client client1, Client client2) {
        String companyId2;
        if (!Objects.equals(client1.getClientId(), client2.getClientId())) {
            return false;
        }
        String companyId1 = MapUtil.getString(client1.getProperties(), (String)"company.id");
        return Objects.equals(companyId1, companyId2 = MapUtil.getString(client2.getProperties(), (String)"company.id"));
    }

    protected abstract ServerAccessToken doCreateAccessToken(Client var1, MultivaluedMap<String, String> var2);

    protected boolean hasCreateTokenPermission(long userId, OAuth2Application oAuth2Application) {
        block7: {
            PermissionChecker permissionChecker;
            try {
                User user = this.userLocalService.getUserById(userId);
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to create permission checker for user " + userId), (Throwable)exception);
                }
                return false;
            }
            try {
                if (this.modelResourcePermission.contains(permissionChecker, (ClassedModel)oAuth2Application, "CREATE_TOKEN")) {
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)("Unable to check permissions for application " + oAuth2Application), (Throwable)portalException);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"User ", userId, " does not have permission to create access token for ", "client ", oAuth2Application.getClientId()}));
        }
        return false;
    }

    protected abstract boolean hasPermission(Client var1, MultivaluedMap<String, String> var2);

    protected abstract boolean isGrantHandlerEnabled();
}

