/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.rest.internal.configuration.OAuth2InAssertionConfiguration;
import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler.BaseAccessTokenGrantHandler;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.jwt.JwtBearerGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={AccessTokenGrantHandler.class})
public class LiferayJWTBearerGrantHandler
extends BaseAccessTokenGrantHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJWTBearerGrantHandler.class);
    private final Map<String, Dictionary<String, ?>> _configurationPidsProperties = new ConcurrentHashMap();
    private final Map<Long, Map<String, Map<String, JwsSignatureVerifier>>> _jwsSignatureVerifiers = new ConcurrentHashMap<Long, Map<String, Map<String, JwsSignatureVerifier>>>();
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private volatile OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;
    private final Map<Long, Map<String, String>> _userAuthTypes = new ConcurrentHashMap<Long, Map<String, String>>();

    @Override
    public List<String> getSupportedGrantTypes() {
        AccessTokenGrantHandler accessTokenGrantHandler = this._getAccessTokenGrantHandler();
        return accessTokenGrantHandler.getSupportedGrantTypes();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new OAuth2InAssertionManagedServiceFactory(), MapUtil.singletonDictionary((Object)"service.pid", (Object)"com.liferay.oauth2.provider.rest.internal.configuration.OAuth2InAssertionConfiguration"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(Client client, MultivaluedMap<String, String> params) {
        AccessTokenGrantHandler accessTokenGrantHandler = this._getAccessTokenGrantHandler();
        return accessTokenGrantHandler.createAccessToken(client, params);
    }

    @Override
    protected boolean hasPermission(Client client, MultivaluedMap<String, String> multivaluedMap) {
        return multivaluedMap.getFirst((Object)"assertion") != null;
    }

    @Override
    protected boolean isGrantHandlerEnabled() {
        return this._oAuth2ProviderConfiguration.allowJWTBearerGrant();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._jwsSignatureVerifiers.put(0L, Collections.emptyMap());
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        this._userAuthTypes.put(0L, Collections.emptyMap());
    }

    private AccessTokenGrantHandler _getAccessTokenGrantHandler() {
        CustomJWTBearerGrantHandler customJWTBearerGrantHandler = new CustomJWTBearerGrantHandler();
        customJWTBearerGrantHandler.setDataProvider(this._liferayOAuthDataProvider);
        return customJWTBearerGrantHandler;
    }

    private JwsSignatureVerifier _getJWSSignatureVerifier(long companyId, String issuer, String kid) throws IllegalArgumentException {
        StringBundler sb = new StringBundler(12);
        Map<String, Map<String, JwsSignatureVerifier>> jwsSignatureVerifiers = this._jwsSignatureVerifiers.getOrDefault(companyId, this._jwsSignatureVerifiers.get(0L));
        if (jwsSignatureVerifiers == null) {
            sb.append("No JWS signature keys in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        Map<String, JwsSignatureVerifier> kidsJWSSignatureVerifiers = jwsSignatureVerifiers.get(issuer);
        if (kidsJWSSignatureVerifiers == null) {
            sb.append("No JWS signature keys for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        if (!kidsJWSSignatureVerifiers.containsKey(kid)) {
            sb.append("No JWS signature key of KID: ");
            sb.append(kid);
            sb.append(", for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        return kidsJWSSignatureVerifiers.get(kid);
    }

    private String _getUserAuthType(long companyId, String issuer) throws IllegalArgumentException {
        StringBundler sb = new StringBundler(6);
        Map<String, String> userAuthTypes = this._userAuthTypes.getOrDefault(companyId, this._userAuthTypes.get(0L));
        if (userAuthTypes == null) {
            sb.append("No user auth types in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        if (!userAuthTypes.containsKey(issuer)) {
            sb.append("No user auth type for issuer: ");
            sb.append(issuer);
            sb.append(", in company: ");
            sb.append(companyId);
            throw new IllegalArgumentException(sb.toString());
        }
        return userAuthTypes.get(issuer);
    }

    private class OAuth2InAssertionManagedServiceFactory
    implements ManagedServiceFactory {
        private OAuth2InAssertionManagedServiceFactory() {
        }

        public void deleted(String pid) {
            Dictionary properties = (Dictionary)LiferayJWTBearerGrantHandler.this._configurationPidsProperties.remove(pid);
            long companyId = GetterUtil.getLong(properties.get("companyId"));
            if (companyId == 0L) {
                this._rebuild();
            } else {
                this._rebuild(companyId);
            }
        }

        public String getName() {
            return "";
        }

        public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
            Dictionary<String, ?> oldProperties = LiferayJWTBearerGrantHandler.this._configurationPidsProperties.put(pid, properties);
            long companyId = GetterUtil.getLong(properties.get("companyId"), (long)0L);
            if (companyId == 0L) {
                this._rebuild();
                return;
            }
            if (oldProperties != null) {
                long oldCompanyId = GetterUtil.getLong(oldProperties.get("companyId"));
                if (oldCompanyId == 0L) {
                    this._rebuild();
                    return;
                }
                if (oldCompanyId != companyId) {
                    this._rebuild(oldCompanyId);
                }
            }
            this._rebuild(companyId);
        }

        private <U, V> void _addDefaults(Map<U, V> map, Map<U, V> defaultsMap) {
            if (defaultsMap != null) {
                defaultsMap.forEach(map::putIfAbsent);
            }
        }

        private void _rebuild() {
            this._rebuild(0L);
            for (Long key : LiferayJWTBearerGrantHandler.this._jwsSignatureVerifiers.keySet()) {
                if (key == 0L) continue;
                this._rebuild(key);
            }
        }

        private void _rebuild(long companyId) {
            HashMap jwsSignatureVerifiers = new HashMap();
            HashMap<String, String> userAuthTypes = new HashMap<String, String>();
            for (Dictionary properties : LiferayJWTBearerGrantHandler.this._configurationPidsProperties.values()) {
                if (companyId != GetterUtil.getLong(properties.get("companyId"))) continue;
                OAuth2InAssertionConfiguration oAuth2InAssertionConfiguration = (OAuth2InAssertionConfiguration)ConfigurableUtil.createConfigurable(OAuth2InAssertionConfiguration.class, (Dictionary)properties);
                String issuer = oAuth2InAssertionConfiguration.issuer();
                if (jwsSignatureVerifiers.containsKey(issuer)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Duplicate issuer name ", issuer, " will be ", "discarded. Check your OAuth configuration."}));
                    continue;
                }
                jwsSignatureVerifiers.put(issuer, new HashMap());
                userAuthTypes.put(issuer, oAuth2InAssertionConfiguration.userAuthType());
                Map kidsJWSSignatureVerifiers = (Map)jwsSignatureVerifiers.get(issuer);
                JsonWebKeys jsonWebKeys = JwkUtils.readJwkSet(oAuth2InAssertionConfiguration.signatureJSONWebKeySet());
                for (JsonWebKey jsonWebKey : jsonWebKeys.getKeys()) {
                    PublicKeyUse publicKeyUse = jsonWebKey.getPublicKeyUse();
                    if (publicKeyUse != null && publicKeyUse.compareTo(PublicKeyUse.ENCRYPT) == 0) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("Encryption key " + jsonWebKey.getKeyId()));
                        continue;
                    }
                    if (kidsJWSSignatureVerifiers.containsKey(jsonWebKey.getKeyId())) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Duplicate assertion signature key ", jsonWebKey.getKeyId(), " will be discarded. Check your OAuth ", "configuration."}));
                        continue;
                    }
                    kidsJWSSignatureVerifiers.put(jsonWebKey.getKeyId(), JwsUtils.getSignatureVerifier(jsonWebKey));
                }
            }
            if (companyId != 0L) {
                this._addDefaults(jwsSignatureVerifiers, (Map)LiferayJWTBearerGrantHandler.this._jwsSignatureVerifiers.get(0L));
                this._addDefaults(userAuthTypes, (Map)LiferayJWTBearerGrantHandler.this._userAuthTypes.get(0L));
            }
            LiferayJWTBearerGrantHandler.this._jwsSignatureVerifiers.put(companyId, jwsSignatureVerifiers);
            LiferayJWTBearerGrantHandler.this._userAuthTypes.put(companyId, userAuthTypes);
        }
    }

    private class CustomJWTBearerGrantHandler
    extends JwtBearerGrantHandler {
        private CustomJWTBearerGrantHandler() {
        }

        @Override
        public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> multivaluedMap) throws OAuthServiceException {
            String assertion = (String)multivaluedMap.getFirst((Object)"assertion");
            Map<String, String> clientProperties = client.getProperties();
            long companyId = GetterUtil.getLong((String)clientProperties.get("company.id"));
            try {
                JwsJwtCompactConsumer jwsJwtCompactConsumer = this.getJwsReader(assertion);
                JwtToken jwtToken = jwsJwtCompactConsumer.getJwtToken();
                JwtClaims jwtClaims = jwtToken.getClaims();
                JwsHeaders jwsHeaders = jwtToken.getJwsHeaders();
                this._initGrantHandler(companyId, jwtClaims, jwsHeaders);
                this.validateSignature(new JwsHeaders(jwsHeaders), jwsJwtCompactConsumer.getUnsignedEncodedSequence(), jwsJwtCompactConsumer.getDecodedSignature());
                this.validateClaims(client, jwtClaims);
                return this.doCreateAccessToken(client, this._createUserSubject(companyId, jwtClaims.getIssuer(), jwtClaims.getSubject()), "urn:ietf:params:oauth:grant-type:jwt-bearer", OAuthUtils.parseScope((String)multivaluedMap.getFirst((Object)"scope")));
            }
            catch (Exception exception) {
                throw new OAuthServiceException(exception);
            }
        }

        private UserSubject _createUserSubject(long companyId, String issuer, String subject) {
            String userAuthType = null;
            try {
                userAuthType = LiferayJWTBearerGrantHandler.this._getUserAuthType(companyId, issuer);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)illegalArgumentException);
                }
                throw new OAuthServiceException("invalid_grant");
            }
            UserSubject userSubject = new UserSubject("");
            if (userAuthType.equals("userId")) {
                userSubject.setId(subject);
                return userSubject;
            }
            Map<String, String> properties = userSubject.getProperties();
            properties.put("company.id", String.valueOf(companyId));
            properties.put(userAuthType, subject);
            return userSubject;
        }

        private void _initGrantHandler(long companyId, JwtClaims jwtClaims, JwsHeaders jwsHeaders) {
            JwsSignatureVerifier jwsSignatureVerifier = null;
            try {
                jwsSignatureVerifier = LiferayJWTBearerGrantHandler.this._getJWSSignatureVerifier(companyId, jwtClaims.getIssuer(), jwsHeaders.getKeyId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)illegalArgumentException);
                }
                throw new OAuthServiceException("invalid_grant");
            }
            this.setJwsVerifier(jwsSignatureVerifier);
        }
    }
}

