/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.internal.endpoint.access.token.grant.handler.BaseAccessTokenGrantHandler;
import com.liferay.oauth2.provider.rest.internal.endpoint.liferay.LiferayOAuthDataProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={AccessTokenGrantHandler.class})
public class LiferayRefreshTokenAccessTokenGrantHandler
extends BaseAccessTokenGrantHandler {
    private static final Log _log = LogFactoryUtil.getLog(LiferayRefreshTokenAccessTokenGrantHandler.class);
    @Reference
    private LiferayOAuthDataProvider _liferayOAuthDataProvider;
    private OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;
    private RefreshTokenGrantHandler _refreshTokenGrantHandler;

    @Override
    public List<String> getSupportedGrantTypes() {
        return this._refreshTokenGrantHandler.getSupportedGrantTypes();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._refreshTokenGrantHandler = new RefreshTokenGrantHandler();
        this._refreshTokenGrantHandler.setDataProvider(this._liferayOAuthDataProvider);
        this._oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(Client client, MultivaluedMap<String, String> params) {
        return this._refreshTokenGrantHandler.createAccessToken(client, params);
    }

    @Override
    protected boolean hasPermission(Client client, MultivaluedMap<String, String> params) {
        String refreshTokenString = (String)params.getFirst((Object)"refresh_token");
        if (refreshTokenString == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No refresh_token parameter was provided");
            }
            return false;
        }
        RefreshToken refreshToken = this._liferayOAuthDataProvider.getRefreshToken(refreshTokenString);
        if (refreshToken == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No refresh token found for " + refreshTokenString));
            }
            return false;
        }
        if (!this.clientsMatch(client, refreshToken.getClient())) {
            this._liferayOAuthDataProvider.doRevokeRefreshToken(refreshToken);
            for (String accessToken : refreshToken.getAccessTokens()) {
                ServerAccessToken serverAccessToken = this._liferayOAuthDataProvider.getAccessToken(accessToken);
                this._liferayOAuthDataProvider.doRevokeAccessToken(serverAccessToken);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticated client does not match the refresh token's client");
            }
            return false;
        }
        UserSubject userSubject = refreshToken.getSubject();
        OAuth2Application oAuth2Application = this._liferayOAuthDataProvider.resolveOAuth2Application(refreshToken.getClient());
        return this.hasCreateTokenPermission(GetterUtil.getLong((String)userSubject.getId()), oAuth2Application);
    }

    @Override
    protected boolean isGrantHandlerEnabled() {
        return this._oAuth2ProviderConfiguration.allowRefreshTokenGrant();
    }
}

