/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.endpoint.info;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Path(value="/application")
@Component(property={"osgi.jaxrs.application.select=(osgi.jaxrs.name=Liferay.OAuth2.Application)", "osgi.jaxrs.name=Liferay.Authorization.Application.Info", "osgi.jaxrs.resource=true"}, service={OAuth2ProviderApplicationInfo.class})
public class OAuth2ProviderApplicationInfo {
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;

    @GET
    @Produces(value={"application/json"})
    public Response get(@QueryParam(value="externalReferenceCode") String externalReferenceCode) {
        OAuth2Application oAuth2Application = null;
        if (!Validator.isBlank((String)externalReferenceCode)) {
            oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2ApplicationByExternalReferenceCode(externalReferenceCode, CompanyThreadLocal.getCompanyId().longValue());
        }
        if (oAuth2Application == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").build();
        }
        return Response.ok((Object)JSONUtil.put((String)"client_id", (Object)oAuth2Application.getClientId()).toString()).build();
    }
}

