/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.jaxrs.feature;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.CollectionScopeFinder;
import com.liferay.oauth2.provider.rest.internal.scope.util.HttpMethodScopeLogicUtil;
import com.liferay.oauth2.provider.rest.spi.scope.checker.container.request.filter.BaseScopeCheckerContainerRequestFilter;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Priority;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Priority(value=1992)
@Provider
@Component(property={"osgi.jaxrs.application.select=(|(&(!(oauth2.scope.checker.type=*))(!(oauth2.scopechecker.type=*)))(|(oauth2.scope.checker.type=http.method)(oauth2.scopechecker.type=http.method)))", "osgi.jaxrs.extension=true", "osgi.jaxrs.extension.select=(osgi.jaxrs.name=Liferay.OAuth2)", "osgi.jaxrs.name=Liferay.OAuth2.HTTP.method.request.checker"}, scope=ServiceScope.PROTOTYPE, service={Feature.class})
public class HttpMethodFeature
implements Feature {
    private static final Log _log = LogFactoryUtil.getLog(HttpMethodFeature.class);
    private BundleContext _bundleContext;
    private Function<String, Object> _propertyAccessorFunction;
    @Reference
    private ScopeChecker _scopeChecker;
    private final Set<String> _scopes = new HashSet<String>();
    private ServiceRegistration<ScopeFinder> _serviceRegistration;

    public boolean configure(FeatureContext featureContext) {
        featureContext.register(this::_collectHttpMethods);
        featureContext.register((Object)new HttpScopeCheckerContainerRequestFilter(), Collections.singletonMap(ContainerRequestFilter.class, 1992));
        Configuration configuration = featureContext.getConfiguration();
        Map applicationProperties = (Map)configuration.getProperty("osgi.jaxrs.application.serviceProperties");
        this._propertyAccessorFunction = applicationProperties::get;
        this._serviceRegistration = this._bundleContext.registerService(ScopeFinder.class, (Object)new CollectionScopeFinder(this._scopes), new Hashtable(applicationProperties));
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    private void _collectHttpMethods(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Method method = resourceInfo.getResourceMethod();
        while (method != null) {
            for (Annotation annotation : method.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                HttpMethod[] annotationsByType = (HttpMethod[])annotationType.getAnnotationsByType(HttpMethod.class);
                if (annotationsByType == null) continue;
                for (HttpMethod httpMethod : annotationsByType) {
                    this._scopes.add(httpMethod.value());
                }
            }
            method = this._getSuperMethod(method);
        }
    }

    private Method _getSuperMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz = clazz.getSuperclass()) == Object.class) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchMethodException);
            }
            return null;
        }
    }

    private class HttpScopeCheckerContainerRequestFilter
    extends BaseScopeCheckerContainerRequestFilter {
        @Context
        private ResourceInfo _resourceInfo;

        private HttpScopeCheckerContainerRequestFilter() {
        }

        public boolean isContainerRequestContextAllowed(ContainerRequestContext containerRequestContext) {
            Request request = containerRequestContext.getRequest();
            return HttpMethodScopeLogicUtil.check(HttpMethodFeature.this._bundleContext, HttpMethodFeature.this._propertyAccessorFunction, HttpMethodFeature.this._scopeChecker, request.getMethod());
        }
    }
}

