/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.scope.logic;

import com.liferay.oauth2.provider.rest.internal.jaxrs.feature.RequiresScopeAnnotationFinder;
import com.liferay.oauth2.provider.rest.internal.scope.logic.ScopeLogic;
import com.liferay.oauth2.provider.scope.RequiresNoScope;
import com.liferay.oauth2.provider.scope.RequiresScope;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.petra.string.StringBundler;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;

@Component(property={"oauth2.scope.checker.type=annotations"}, service={ScopeLogic.class})
public class AnnotationScopeLogic
implements ScopeLogic {
    @Override
    public boolean check(Function<String, Object> propertyAccessorFunction, Class<?> resourceClass, Method resourceMethod, ScopeChecker scopeChecker) {
        RequiresNoScope requiresNoScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceMethod, RequiresNoScope.class);
        RequiresScope requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceMethod, RequiresScope.class);
        if (requiresNoScope != null && requiresScope != null) {
            StringBundler sb = new StringBundler(6);
            Class<?> declaringClass = resourceMethod.getDeclaringClass();
            sb.append("Method ");
            sb.append(declaringClass.getName());
            sb.append("#");
            sb.append(resourceMethod.getName());
            sb.append("has both @RequiresNoScope and @RequiresScope ");
            sb.append("annotations defined");
            throw new RuntimeException(sb.toString());
        }
        if (requiresNoScope != null || this._checkRequiresScope(scopeChecker, requiresScope)) {
            return true;
        }
        requiresNoScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceClass, RequiresNoScope.class);
        requiresScope = RequiresScopeAnnotationFinder.getScopeAnnotation(resourceClass, RequiresScope.class);
        if (requiresNoScope != null && requiresScope != null) {
            throw new RuntimeException(StringBundler.concat((String[])new String[]{"Class ", resourceClass.getName(), "has both @RequiresNoScope and @RequiresScope annotations ", "defined"}));
        }
        return requiresNoScope != null || this._checkRequiresScope(scopeChecker, requiresScope);
    }

    private boolean _checkRequiresScope(ScopeChecker scopeChecker, RequiresScope requiresScope) {
        if (requiresScope != null) {
            if (requiresScope.allNeeded()) {
                return scopeChecker.checkAllScopes(requiresScope.value());
            }
            return scopeChecker.checkAnyScope(requiresScope.value());
        }
        return false;
    }
}

