/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.scope.logic;

import com.liferay.oauth2.provider.rest.internal.scope.logic.ScopeLogic;
import com.liferay.oauth2.provider.rest.internal.scope.util.HttpMethodScopeLogicUtil;
import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.HttpMethod;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"oauth2.scope.checker.type=http.method"}, service={ScopeLogic.class})
public class HttpMethodScopeLogic
implements ScopeLogic {
    private static final Log _log = LogFactoryUtil.getLog(HttpMethodScopeLogic.class);
    private BundleContext _bundleContext;

    @Override
    public boolean check(Function<String, Object> propertyAccessorFunction, Class<?> resourceClass, Method resourceMethod, ScopeChecker scopeChecker) {
        return HttpMethodScopeLogicUtil.check(this._bundleContext, propertyAccessorFunction, scopeChecker, this._getHttpMethod(resourceMethod));
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
    }

    private String _getHttpMethod(Method method) {
        while (method != null) {
            for (Annotation annotation : method.getAnnotations()) {
                HttpMethod[] httpMethodArray;
                int n;
                int n2;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                HttpMethod[] annotationsByType = (HttpMethod[])annotationType.getAnnotationsByType(HttpMethod.class);
                if (annotationsByType == null || (n2 = 0) >= (n = (httpMethodArray = annotationsByType).length)) continue;
                HttpMethod httpMethod = httpMethodArray[n2];
                return httpMethod.value();
            }
            method = this._getSuperMethod(method);
        }
        throw new UnsupportedOperationException();
    }

    private Method _getSuperMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz = clazz.getSuperclass()) == Object.class) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchMethodException);
            }
            return null;
        }
    }
}

