/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.scope.util;

import com.liferay.oauth2.provider.scope.ScopeChecker;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HttpMethodScopeLogicUtil {
    private static final Log _log = LogFactoryUtil.getLog(HttpMethodScopeLogicUtil.class);
    private static final Set<String> _defaultIgnoreMissingScopes = new HashSet<String>(Arrays.asList("HEAD", "OPTIONS"));

    public static boolean check(BundleContext bundleContext, Function<String, Object> propertyAccessorFunction, ScopeChecker scopeChecker, String requestMethod) {
        block4: {
            try {
                String applicationName = GetterUtil.getString((Object)propertyAccessorFunction.apply("osgi.jaxrs.name"));
                Object ignoreMissingScopesObject = propertyAccessorFunction.apply("ignore.missing.scopes");
                Set<String> ignoreMissingScopes = _defaultIgnoreMissingScopes;
                if (ignoreMissingScopesObject != null) {
                    ignoreMissingScopes = new HashSet<String>(StringPlus.asList((Object)ignoreMissingScopesObject));
                }
                ServiceReference<ScopeFinder> serviceReference = HttpMethodScopeLogicUtil._getServiceReference(bundleContext, ScopeFinder.class, applicationName);
                ScopeFinder scopeFinder = (ScopeFinder)bundleContext.getService(serviceReference);
                bundleContext.ungetService(serviceReference);
                Collection scopes = scopeFinder.findScopes();
                if (!scopes.contains(requestMethod) && ignoreMissingScopes.contains(requestMethod) || scopeChecker.checkScope(requestMethod)) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Throwable)exception);
            }
        }
        return false;
    }

    private static <T> ServiceReference<? extends T> _getServiceReference(BundleContext bundleContext, Class<? extends T> clazz, String applicationName) throws Exception {
        List serviceReferences = (List)bundleContext.getServiceReferences(clazz, "(osgi.jaxrs.name=" + applicationName + ")");
        if (ListUtil.isNotEmpty((List)serviceReferences)) {
            return (ServiceReference)serviceReferences.get(0);
        }
        throw new UnsupportedOperationException("Invalid JAX-RS application " + applicationName);
    }
}

