/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.rest.internal.service.access.policy;

import com.liferay.osgi.util.configuration.ConfigurationPersistenceUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class OAuth2RESTSAPEntryPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final String[][] _SAP_ENTRY_OBJECT_ARRAYS = new String[][]{{"AUTHORIZED_OAUTH2_SAP", "*"}};
    private static final Log _log = LogFactoryUtil.getLog(OAuth2RESTSAPEntryPortalInstanceLifecycleListener.class);
    private boolean _createSapEntriesOnStartup;
    private long _lastModifiedTime;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._createSapEntriesOnStartup) {
            return;
        }
        try {
            this._addSAPEntries(company.getCompanyId());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        this._createSapEntriesOnStartup = MapUtil.getBoolean(properties, (String)"oauth2.create.oauth2.sap.entries.on.startup", (boolean)true);
        this._lastModifiedTime = ConfigurationPersistenceUtil.update((Object)((Object)this), properties);
    }

    private void _addSAPEntries(long companyId) throws PortalException {
        for (String[] sapEntryObjectArray : _SAP_ENTRY_OBJECT_ARRAYS) {
            String name = sapEntryObjectArray[0];
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, name);
            if (sapEntry != null) continue;
            String allowedServiceSignatures = sapEntryObjectArray[1];
            Map map = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)ResourceBundleLoaderUtil.getPortalResourceBundleLoader(), (String)name);
            this._sapEntryLocalService.addSAPEntry(this._userLocalService.getGuestUserId(companyId), allowedServiceSignatures, false, true, name, map, new ServiceContext());
        }
    }
}

